/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.events;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.CharacterInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class OnServerTick {
    public static void tick(MinecraftServer server) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
            ArrayList<InkAction> toRemove = new ArrayList<InkAction>();
            List<InkAction> inkActionsServer = playerSession.getServerSideInkActions();
            for (InkAction inkAction : inkActionsServer) {
                if (!inkAction.isRunning()) {
                    toRemove.add(inkAction);
                }
                inkAction.tick();
            }
            playerSession.getInkActions().removeAll(toRemove);
            StoryHandler storyHandler = playerSession.getStoryHandler();
            KeyframeLocation location = playerSession.getCurrentCamera();
            if (location != null) {
                playerSession.getPlayer().connection.teleport(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            }
            if (storyHandler == null || !playerSession.isOnGameplay() || playerSession.getCurrentCamera() != null) continue;
            Vec3 pPosition = playerSession.getPlayer().position();
            Object areaTriggerInside = null;
            for (InteractionController interactionController : playerSession.getInteractionControllers()) {
                for (AreaTrigger areaTrigger : interactionController.getAreaTriggers()) {
                    if (!AreaTrigger.isInside(areaTrigger, pPosition)) continue;
                    areaTriggerInside = areaTrigger;
                }
            }
            if (areaTriggerInside != null && !areaTriggerInside.equals(playerSession.getLastAreaTriggerEntered())) {
                if (((AreaTrigger)areaTriggerInside).isUnique() && playerSession.getAreaTriggersEntered().contains(areaTriggerInside)) continue;
                storyHandler.playStitch(((AreaTrigger)areaTriggerInside).getStitch());
                playerSession.addAreaTriggerEntered((AreaTrigger)areaTriggerInside);
                playerSession.setLastAreaTriggerEntered((AreaTrigger)areaTriggerInside);
            } else if (areaTriggerInside == null && playerSession.getLastAreaTriggerEntered() != null) {
                playerSession.setLastAreaTriggerEntered(null);
            }
            playerSession.setLookingAtEntityId(-1);
            for (InteractionController interactionController : playerSession.getInteractionControllers()) {
                for (CharacterInteraction characterInteraction : interactionController.getCharacterInteractions()) {
                    LivingEntity livingEntity;
                    LivingEntity livingEntity2;
                    if (characterInteraction.getStitch().isEmpty() || playerSession.getDialogRenderer() != null && playerSession.getLastInteraction() != null && playerSession.getLastInteraction().getStitch().equals(characterInteraction.getStitch()) || !((livingEntity2 = characterInteraction.getCharacterStoryData().getCharacterRuntime().getEntity()) instanceof LivingEntity) || !(pPosition.distanceTo((livingEntity = livingEntity2).position()) <= 5.0) || !Util.isLookingAtMe((LivingEntity)player, livingEntity, 0.2, true, false, livingEntity.getY() + (double)(livingEntity.getBbHeight() / 2.0f))) continue;
                    playerSession.setLookingAtEntityId(livingEntity.getId());
                }
                for (EntityInteraction entityInteraction : interactionController.getEntityInteractions()) {
                    if (entityInteraction.getStitch().isEmpty() || playerSession.getDialogRenderer() != null && playerSession.getLastInteraction() != null && playerSession.getLastInteraction().getStitch().equals(entityInteraction.getStitch()) || !(pPosition.distanceTo(entityInteraction.getArmorStand().position()) <= 5.0) || !Util.isLookingAtMe((LivingEntity)player, (LivingEntity)entityInteraction.getArmorStand(), 0.2, true, false, entityInteraction.getArmorStand().getY() + (double)(entityInteraction.getArmorStand().getBbHeight() / 2.0f))) continue;
                    playerSession.setLookingAtEntityId(entityInteraction.getArmorStand().getId());
                }
            }
        }
    }
}

