/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.managers;

import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public class CharacterManager {
    private final List<CharacterStory> characterStories = new ArrayList<CharacterStory>();

    public void addCharacter(CharacterStory characterStory) {
        if (this.characterStories.contains(characterStory)) {
            return;
        }
        this.characterStories.add(characterStory);
    }

    public void removeCharacter(CharacterStory characterStory) {
        this.characterStories.remove(characterStory);
    }

    public CharacterStory getCharacterByName(String name) {
        for (CharacterStory characterStory : this.characterStories) {
            if (!characterStory.getName().equalsIgnoreCase(name)) continue;
            return characterStory;
        }
        return null;
    }

    public boolean characterExists(String name) {
        for (CharacterStory characterStory : this.characterStories) {
            if (!characterStory.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<CharacterStory> getCharacterStories() {
        return this.characterStories;
    }

    public List<EntityType<?>> getAvailableEntityTypes() {
        ArrayList finalList = new ArrayList();
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE.stream().toList()) {
            String key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).getPath();
            if (entityType.getCategory() == MobCategory.MISC && !key.equals("player") && !key.equals("villager") && !key.equals("mannequin")) continue;
            finalList.add(entityType);
        }
        return finalList;
    }

    public CharacterStory getMainCharacter() {
        List<CharacterStory> mainCharacters = this.characterStories.stream().filter(characterStory -> characterStory.getMainCharacterAttribute().isMainCharacter()).toList();
        if (mainCharacters.isEmpty()) {
            return null;
        }
        return mainCharacters.get(0);
    }
}

