/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.AbstractController;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin {
    @Shadow
    @Final
    private Quaternionf rotation;

    @Shadow
    protected abstract void setPosition(double var1, double var3, double var5);

    @Shadow
    protected abstract void setRotation(float var1, float var2);

    @Inject(method={"setup"}, at={@At(value="RETURN")})
    private void narrativecraft$cameraSetup(BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTick, CallbackInfo ci) {
        LocalPlayer player = Minecraft.getInstance().player;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        if (playerSession == null) {
            return;
        }
        AbstractController abstractController = playerSession.getController();
        if (abstractController instanceof CutsceneController) {
            CutsceneController controller = (CutsceneController)abstractController;
            controller.getCutscenePlayback().cameraInterpolation(partialTick);
        }
        if (playerSession.getCurrentCamera() == null) {
            return;
        }
        KeyframeLocation location = playerSession.getCurrentCamera();
        this.setPosition(location.getX(), location.getY(), location.getZ());
        this.setRotation(location.getYaw(), location.getPitch());
        this.rotation.rotateZ(-((float)Math.toRadians(location.getRoll())));
    }
}

