/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public abstract class MinecraftCommonMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    public HitResult hitResult;

    @Shadow
    public abstract void setScreen(@Nullable Screen var1);

    @Redirect(method={"pauseGame"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"))
    private void narrativecraft$pauseGame(Minecraft instance, Screen old) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)instance.player);
        if (playerSession == null) {
            instance.setScreen(old);
            return;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            instance.setScreen(old);
        } else {
            MainScreen mainScreen = new MainScreen(playerSession, false, true);
            this.setScreen(mainScreen);
        }
    }

    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void narrativecraft$startAttack(CallbackInfoReturnable<Boolean> cir) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)this.player);
        if (playerSession == null) {
            return;
        }
        if (playerSession.getCurrentCamera() != null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (playerSession.getStoryHandler() == null) {
            return;
        }
        if (this.hitResult == null) {
            return;
        }
        HitResult hitResult = this.hitResult;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            NarrativeCraftMod.server.execute(() -> {
                if (playerSession.getStoryHandler().interactWith(entityHitResult.getEntity())) {
                    cir.setReturnValue((Object)false);
                }
            });
        }
    }
}

