/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import com.mojang.authlib.GameProfile;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.MainCharacterAttribute;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Util;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerInfo.class})
public class PlayerInfoMixin {
    @Shadow
    @Final
    private GameProfile profile;

    @Inject(method={"getProfile"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$getProfile(CallbackInfoReturnable<GameProfile> callbackInfo) {
        if (!"_username_".equals(this.profile.getName())) {
            return;
        }
        GameProfile originalProfile = (GameProfile)callbackInfo.getReturnValue();
        String playerName = Minecraft.getInstance().player.getName().getString();
        callbackInfo.setReturnValue((Object)new GameProfile(originalProfile.getId(), playerName));
    }

    @Inject(method={"getSkin"}, at={@At(value="RETURN")}, cancellable=true)
    private void narrativecraft$getSkin(CallbackInfoReturnable<PlayerSkin> callbackInfo) {
        ResourceLocation mainCharacterSkin;
        CharacterStory mainCharacter;
        Minecraft minecraft = Minecraft.getInstance();
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)minecraft.player);
        if (playerSession == null) {
            return;
        }
        if (minecraft.player.getGameProfile().equals((Object)this.profile) && playerSession.getStoryHandler() != null && (mainCharacter = NarrativeCraftMod.getInstance().getCharacterManager().getMainCharacter()) != null && mainCharacter.getMainCharacterAttribute().isSameSkinAsTheir() && (mainCharacterSkin = NarrativeCraftFile.getMainCharacterSkin()) != null) {
            PlayerSkin.Model playerModelType;
            try {
                playerModelType = PlayerSkin.Model.valueOf((String)mainCharacter.getModel().name());
            }
            catch (IllegalArgumentException exception) {
                playerModelType = PlayerSkin.Model.WIDE;
            }
            PlayerSkin playerSkin = new PlayerSkin(mainCharacterSkin, null, null, null, playerModelType, true);
            callbackInfo.setReturnValue((Object)playerSkin);
            return;
        }
        for (CharacterRuntime characterRuntime : new ArrayList<CharacterRuntime>(playerSession.getCharacterRuntimes())) {
            PlayerSkin.Model playerModelType;
            if (characterRuntime.getEntity() == null) continue;
            CharacterStory characterStory = characterRuntime.getCharacterStory();
            MainCharacterAttribute mainCharacterAttribute = characterStory.getMainCharacterAttribute();
            try {
                playerModelType = PlayerSkin.Model.valueOf((String)characterStory.getModel().name());
            }
            catch (IllegalArgumentException exception) {
                playerModelType = PlayerSkin.Model.WIDE;
            }
            File currentSkinFile = characterRuntime.getCharacterSkinController().getCurrentSkin();
            if (currentSkinFile == null) continue;
            ResourceLocation skinLocation = ResourceLocation.fromNamespaceAndPath((String)"narrativecraft", (String)("character/" + Util.snakeCase(characterStory.getName()) + "/" + Util.snakeCase(currentSkinFile.getName())));
            PlayerSkin playerSkin = new PlayerSkin(skinLocation, null, null, null, playerModelType, true);
            if (!this.profile.getName().equals(characterStory.getName())) continue;
            if (mainCharacterAttribute.isMainCharacter() && mainCharacterAttribute.isSameSkinAsPlayer()) {
                callbackInfo.setReturnValue((Object)minecraft.player.getSkin());
                return;
            }
            callbackInfo.setReturnValue((Object)playerSkin);
        }
    }
}

