/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import fr.loudo.narrativecraft.audio.VolumeAudio;
import fr.loudo.narrativecraft.narrative.story.inkAction.sound.SoundInkInstance;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements VolumeAudio {
    @Shadow
    private boolean loaded;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;

    @Shadow
    protected abstract float calculateVolume(SoundInstance var1);

    @Override
    public void narrativecraft$setVolume(SoundInstance soundInstance, float volume) {
        ChannelAccess.ChannelHandle channelHandle;
        if (this.loaded && (channelHandle = this.instanceToChannel.get(soundInstance)) != null) {
            channelHandle.execute(channel -> channel.setVolume(volume * this.calculateVolume(soundInstance)));
        }
    }

    @Redirect(method={"updateCategoryVolume"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V"))
    private void narrativecraft$updateCategoryVolume(Map<SoundInstance, ChannelAccess.ChannelHandle> instance, BiConsumer<? super SoundInstance, ? super ChannelAccess.ChannelHandle> v) {
        instance.forEach((soundInstance, channelHandle) -> {
            if (soundInstance instanceof SoundInkInstance) {
                return;
            }
            float f = this.calculateVolume((SoundInstance)soundInstance);
            channelHandle.execute(channel -> channel.setVolume(f));
        });
    }
}

