/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter.scene.data;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.SceneData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AreaTrigger
extends SceneData {
    private double x1;
    private double y1;
    private double z1;
    private double x2;
    private double y2;
    private double z2;
    private boolean isUnique;
    private String stitch;

    public AreaTrigger(String name, String description, Scene scene, String stitch, boolean isUnique) {
        super(name, description, scene);
        this.stitch = stitch;
        this.isUnique = isUnique;
    }

    public void setPosition1(Vec3 vec3) {
        this.x1 = Math.floor(vec3.x());
        this.y1 = Math.floor(vec3.y());
        this.z1 = Math.floor(vec3.z());
        if (this.x2 == 0.0 && this.y2 == 0.0 && this.z2 == 0.0) {
            this.x2 = Math.floor(vec3.x());
            this.y2 = Math.floor(vec3.y());
            this.z2 = Math.floor(vec3.z());
        }
    }

    public void setPosition2(Vec3 vec3) {
        this.x2 = Math.floor(vec3.x());
        this.y2 = Math.floor(vec3.y());
        this.z2 = Math.floor(vec3.z());
    }

    public AABB getBoundingBox() {
        double minX = Math.min(this.x1, this.x2);
        double minY = Math.min(this.y1, this.y2);
        double minZ = Math.min(this.z1, this.z2);
        double maxX = Math.max(this.x1, this.x2) + 1.0;
        double maxY = Math.max(this.y1, this.y2) + 1.0;
        double maxZ = Math.max(this.z1, this.z2) + 1.0;
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Vec3 getPosition1() {
        return new Vec3(this.x1, this.y1, this.z1);
    }

    public Vec3 getPosition2() {
        return new Vec3(this.x2, this.y2, this.z2);
    }

    public String getStitch() {
        return this.stitch;
    }

    public void setStitch(String stitch) {
        this.stitch = stitch;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setUnique(boolean unique) {
        this.isUnique = unique;
    }

    public void drawSquareLine(PoseStack poseStack) {
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        PoseStack.Pose matrix4f = poseStack.last();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        VertexConsumer vertex = bufferSource.getBuffer(RenderType.lines());
        double minX = Math.min(this.x1, this.x2);
        double minY = Math.min(this.y1, this.y2);
        double minZ = Math.min(this.z1, this.z2);
        double maxX = Math.max(this.x1, this.x2);
        double maxY = Math.max(this.y1, this.y2) + 1.0;
        double maxZ = Math.max(this.z1, this.z2);
        minX -= camPos.x;
        minY -= camPos.y;
        minZ -= camPos.z;
        maxX -= camPos.x;
        maxY -= camPos.y;
        maxZ -= camPos.z;
        Matrix4f matrix = matrix4f.pose();
        float r = 0.09f;
        float g = 0.38f;
        float b = 0.85f;
        float a = 1.0f;
        Vec3 p000 = new Vec3(minX, minY, minZ);
        Vec3 p001 = new Vec3(minX, minY, maxZ);
        Vec3 p010 = new Vec3(minX, maxY, minZ);
        Vec3 p011 = new Vec3(minX, maxY, maxZ);
        Vec3 p100 = new Vec3(maxX, minY, minZ);
        Vec3 p101 = new Vec3(maxX, minY, maxZ);
        Vec3 p110 = new Vec3(maxX, maxY, minZ);
        Vec3 p111 = new Vec3(maxX, maxY, maxZ);
        this.drawEdge(vertex, matrix, p000, p100, r, g, b, a);
        this.drawEdge(vertex, matrix, p100, p101, r, g, b, a);
        this.drawEdge(vertex, matrix, p101, p001, r, g, b, a);
        this.drawEdge(vertex, matrix, p001, p000, r, g, b, a);
        this.drawEdge(vertex, matrix, p010, p110, r, g, b, a);
        this.drawEdge(vertex, matrix, p110, p111, r, g, b, a);
        this.drawEdge(vertex, matrix, p111, p011, r, g, b, a);
        this.drawEdge(vertex, matrix, p011, p010, r, g, b, a);
        this.drawEdge(vertex, matrix, p000, p010, r, g, b, a);
        this.drawEdge(vertex, matrix, p100, p110, r, g, b, a);
        this.drawEdge(vertex, matrix, p101, p111, r, g, b, a);
        this.drawEdge(vertex, matrix, p001, p011, r, g, b, a);
        bufferSource.endBatch(RenderType.lines());
    }

    private void drawEdge(VertexConsumer vertex, Matrix4f matrix, Vec3 a, Vec3 b, float r, float g, float bcol, float alpha) {
        vertex.addVertex(matrix, (float)a.x, (float)a.y, (float)a.z).setColor(r, g, bcol, alpha).setNormal(0.0f, 1.0f, 0.0f);
        vertex.addVertex(matrix, (float)b.x, (float)b.y, (float)b.z).setColor(r, g, bcol, alpha).setNormal(0.0f, 1.0f, 0.0f);
    }

    public static boolean isInside(AreaTrigger areaTrigger, Vec3 pPosition) {
        Vec3 pos1 = areaTrigger.getPosition1();
        Vec3 pos2 = areaTrigger.getPosition2();
        double minX = Math.min(pos1.x, pos2.x);
        double maxX = Math.max(pos1.x, pos2.x);
        double minY = Math.min(pos1.y, pos2.y);
        double maxY = Math.max(pos1.y, pos2.y);
        double minZ = Math.min(pos1.z, pos2.z);
        double maxZ = Math.max(pos1.z, pos2.z);
        return pPosition.x >= minX && pPosition.x <= maxX && pPosition.y >= minY && pPosition.y <= maxY && pPosition.z >= minZ && pPosition.z <= maxZ;
    }
}

