/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction;

import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.StitchInteraction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.phys.Vec3;

public class EntityInteraction
extends StitchInteraction {
    private transient ArmorStand armorStand;
    private final double x;
    private final double y;
    private final double z;

    public EntityInteraction(String stitch, Vec3 position) {
        super(stitch);
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
    }

    public void spawn(ServerPlayer player, Environment environment) {
        this.armorStand = new ArmorStand(EntityType.ARMOR_STAND, player.level());
        this.armorStand.setInvisible(true);
        this.armorStand.setGlowingTag(environment == Environment.DEVELOPMENT);
        this.armorStand.setNoGravity(true);
        this.armorStand.setNoBasePlate(true);
        this.armorStand.moveTo(new Vec3(this.x, this.y, this.z));
        player.connection.send((Packet)new ClientboundAddEntityPacket(this.armorStand.getId(), this.armorStand.getUUID(), this.x, this.y, this.z, 0.0f, 0.0f, EntityType.ARMOR_STAND, 0, new Vec3(0.0, 0.0, 0.0), 0.0));
        player.connection.send((Packet)new ClientboundSetEntityDataPacket(this.armorStand.getId(), this.armorStand.getEntityData().getNonDefaultValues()));
    }

    public void kill(ServerPlayer player) {
        if (this.armorStand == null) {
            return;
        }
        player.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.armorStand.getId()}));
    }

    public Vec3 getPosition() {
        return new Vec3(this.x, this.y, this.z);
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }
}

