/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.animation.DialogArrowSkip;
import fr.loudo.narrativecraft.util.Easing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class DialogRenderer2D
extends DialogRenderer {
    private int widthBox;
    private int heightBox;
    private int offsetHeight;

    public DialogRenderer2D(String text, int widthText, int widthBox, int heightBox, int offsetHeight, float letterSpacing, float gap, int backgroundColor, int textColor) {
        super(text.trim(), widthText, 0.0f, 0.0f, 1.0f, letterSpacing, gap, backgroundColor, textColor);
        this.offsetHeight = offsetHeight;
        this.dialogArrowSkip = new DialogArrowSkip(this, 3.5f, 3.5f, -5.0f, -6.0f, -1);
        this.widthBox = widthBox;
        this.heightBox = heightBox;
        this.dialogAppearTime = 0.4;
    }

    public DialogRenderer2D(String text, int widthText, int widthBox, int heightBox, int offsetHeight, DialogData dialogData) {
        super(text.trim(), widthText, 0.0f, 0.0f, 1.0f, dialogData.getLetterSpacing(), dialogData.getGap(), dialogData.getBackgroundColor(), dialogData.getTextColor());
        this.offsetHeight = offsetHeight;
        this.dialogArrowSkip = new DialogArrowSkip(this, 3.5f, 3.5f, -5.0f, -6.0f, -1);
        this.widthBox = widthBox;
        this.heightBox = heightBox;
        this.dialogAppearTime = 0.4;
    }

    @Override
    public void render(GuiGraphics guiGraphics, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float originalScale = this.scale;
        if (this.currentTick < this.totalTick) {
            double t = this.t(partialTick);
            t = Easing.SMOOTH.interpolate(t);
            if (this.dialogStarting || this.dialogStopping) {
                double opacity;
                if (this.dialogStarting) {
                    originalScale = (float)Mth.lerp((double)t, (double)0.8, (double)this.scale);
                    opacity = Mth.lerp((double)t, (double)0.0, (double)1.0);
                } else {
                    originalScale = (float)Mth.lerp((double)t, (double)this.scale, (double)0.8);
                    opacity = Mth.lerp((double)t, (double)0.8, (double)0.0);
                }
                this.backgroundColor = FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.backgroundColor);
            }
        }
        if (this.currentTick == this.totalTick) {
            if (this.dialogStopping && !this.dialogStarting) {
                this.dialogStopping = false;
            }
            if (this.dialogStarting && !this.dialogStopping) {
                this.dialogStarting = false;
            }
        }
        int windowWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int windowHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int offsetDialog = this.offsetHeight;
        int guiScale = (Integer)this.minecraft.options.guiScale().get();
        switch (guiScale) {
            case 1: {
                offsetDialog *= 4;
            }
            case 2: {
                offsetDialog *= 2;
            }
        }
        int centerX = windowWidth / 2;
        int centerY = windowHeight - offsetDialog - this.heightBox / 2;
        poseStack.translate((float)centerX, (float)centerY, 0.0f);
        poseStack.scale(originalScale, originalScale, originalScale);
        poseStack.translate((float)(-this.widthBox) / 2.0f, (float)(-this.heightBox) / 2.0f, 0.0f);
        guiGraphics.fill(0, 0, this.widthBox, this.heightBox, this.backgroundColor);
        poseStack.translate((float)this.widthBox / 2.0f - 4.0f, (float)this.heightBox / 2.0f, 0.0f);
        if (!this.dialogStopping) {
            this.dialogScrollTextDialog.render(guiGraphics, partialTick);
            if (this.dialogScrollTextDialog.isFinished()) {
                if (!this.dialogAutoSkipping) {
                    this.dialogAutoSkipping = true;
                    this.currentTick = 0;
                }
                this.dialogArrowSkip.start();
            }
            if (!this.noSkip) {
                poseStack.pushPose();
                poseStack.translate((float)this.widthBox / 2.0f, (float)this.heightBox / 2.0f - 10.0f, 0.0f);
                this.dialogArrowSkip.render(guiGraphics, partialTick);
                poseStack.popPose();
            }
        }
        poseStack.popPose();
    }

    public int getWidthBox() {
        return this.widthBox;
    }

    public void setWidthBox(int widthBox) {
        this.widthBox = widthBox;
    }

    public int getHeightBox() {
        return this.heightBox;
    }

    public void setHeightBox(int heightBox) {
        this.heightBox = heightBox;
    }

    public int getOffsetHeight() {
        return this.offsetHeight;
    }

    public void setOffsetHeight(int offsetHeight) {
        this.offsetHeight = offsetHeight;
    }
}

