/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.dialog.DialogEntityBobbing;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.narrative.dialog.geometric.DialogTail;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.Position2D;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class DialogRenderer3D
extends DialogRenderer {
    private final DialogTail dialogTail;
    private final String characterName;
    private DialogEntityBobbing dialogEntityBobbing;
    private Position2D dialogOffset;
    private CharacterRuntime characterRuntime;
    private Vec3 dialogPosition;

    public DialogRenderer3D(String text, String characterName, CharacterRuntime characterRuntime, Position2D dialogOffset, float width, float paddingX, float paddingY, float scale, float letterSpacing, float gap, int backgroundColor, int textColor) {
        super(text, width, paddingX, paddingY, scale, letterSpacing, gap, backgroundColor, textColor);
        this.characterName = characterName;
        this.characterRuntime = characterRuntime;
        this.dialogOffset = dialogOffset;
        this.dialogTail = new DialogTail(this, 5.0f, 10.0f, 0.0f);
    }

    public DialogRenderer3D(String text, String characterName, DialogData dialogData, CharacterRuntime characterRuntime) {
        super(text, dialogData);
        this.characterName = characterName;
        this.characterRuntime = characterRuntime;
        this.dialogOffset = dialogData.getOffset();
        this.dialogTail = new DialogTail(this, 5.0f, 10.0f, 0.0f);
    }

    @Override
    public void tick() {
        if (this.dialogPosition == null) {
            return;
        }
        this.dialogEntityBobbing.tick();
        super.tick();
    }

    private void updateDialogPosition(float partialTick) {
        Entity entity;
        LivingEntity serverEntity = this.characterRuntime.getEntity();
        if (serverEntity != null && (entity = this.minecraft.level.getEntity(this.characterRuntime.getEntity().getId())) != null) {
            if (this.dialogPosition != null) {
                Vec3 newPos = entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0);
                double x = Mth.lerp((double)partialTick, (double)this.dialogPosition.x, (double)newPos.x);
                double y = Mth.lerp((double)partialTick, (double)this.dialogPosition.y, (double)newPos.y);
                double z = Mth.lerp((double)partialTick, (double)this.dialogPosition.z, (double)newPos.z);
                this.dialogPosition = new Vec3(x, y, z);
            } else {
                this.dialogPosition = entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0);
            }
        }
    }

    @Override
    public void render(PoseStack poseStack, float partialTick) {
        this.updateDialogPosition(partialTick);
        if (this.dialogPosition == null) {
            return;
        }
        Vec3 position = this.dialogPosition;
        position = this.translateToRelativeApplyOffset(position);
        float originalScale = this.scale;
        if (this.currentTick < this.totalTick) {
            double t = this.t(partialTick);
            t = Easing.SMOOTH.interpolate(t);
            if (this.dialogStarting || this.dialogStopping) {
                double opacity;
                if (this.dialogStarting) {
                    originalScale = (float)Mth.lerp((double)t, (double)0.0, (double)this.scale);
                    opacity = Mth.lerp((double)t, (double)0.0, (double)1.0);
                    position = this.getDialogInterpolatedAppearPosition(t);
                } else {
                    originalScale = (float)Mth.lerp((double)t, (double)this.scale, (double)0.0);
                    opacity = Mth.lerp((double)t, (double)1.0, (double)0.0);
                    position = this.getDialogInterpolatedDisappearPosition(t);
                }
                this.backgroundColor = FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.backgroundColor);
            } else {
                originalScale = (float)Mth.lerp((double)t, (double)this.oldScale, (double)this.scale);
            }
        }
        if (this.currentTick == this.totalTick) {
            if (this.dialogStopping && !this.dialogStarting) {
                this.dialogStopping = false;
            }
            if (this.dialogStarting && !this.dialogStopping) {
                this.dialogStarting = false;
            }
        }
        poseStack.translate(position.x, position.y, position.z);
        poseStack.mulPose(this.minecraft.getEntityRenderDispatcher().camera.rotation());
        poseStack.scale(originalScale * 0.025f, -originalScale * 0.025f, originalScale * 0.025f);
        this.renderDialogBackground(poseStack, partialTick);
        Side side = this.dialogOffsetSide();
        poseStack.pushPose();
        if (side == Side.DOWN) {
            poseStack.translate(0.0f, this.dialogOffset.x == 0.0f ? this.height : this.height / 2.0f + this.paddingY / 2.0f, 0.0f);
        }
        this.dialogTail.render(poseStack, partialTick, this.minecraft.renderBuffers().bufferSource(), this.minecraft.gameRenderer.getMainCamera());
        poseStack.popPose();
        if (this.dialogOffset.y == 0.0f) {
            switch (side.ordinal()) {
                case 2: 
                case 3: {
                    poseStack.translate(0.0f, 0.0f, 0.0f);
                }
            }
        }
        poseStack.pushPose();
        if (side == Side.RIGHT) {
            if (this.dialogOffset.y == 0.0f) {
                poseStack.translate(this.totalWidth, this.totalHeight / 2.0f, 0.0f);
            } else if (this.dialogOffset.y > 0.0f) {
                poseStack.translate(this.totalWidth, 0.0f, 0.0f);
            } else if (this.dialogOffset.y < 0.0f) {
                poseStack.translate(this.totalWidth, this.totalHeight, 0.0f);
            }
        } else if (side == Side.LEFT) {
            if (this.dialogOffset.y == 0.0f) {
                poseStack.translate(-this.totalWidth, this.totalHeight / 2.0f, 0.0f);
            } else if (this.dialogOffset.y > 0.0f) {
                poseStack.translate(-this.totalWidth, 0.0f, 0.0f);
            } else if (this.dialogOffset.y < 0.0f) {
                poseStack.translate(-this.totalWidth, this.totalHeight, 0.0f);
            }
        } else if (side == Side.DOWN) {
            poseStack.translate(0.0f, this.totalHeight, 0.0f);
        }
        if (!this.dialogStopping) {
            this.dialogEntityBobbing.partialTick(partialTick);
            this.dialogScrollTextDialog.render(poseStack, this.minecraft.renderBuffers().bufferSource(), partialTick);
            if (this.dialogScrollTextDialog.isFinished()) {
                if (!this.dialogAutoSkipping) {
                    this.dialogAutoSkipping = true;
                    this.currentTick = 0;
                }
                this.dialogArrowSkip.start();
            }
            if (!this.noSkip) {
                this.dialogArrowSkip.render(poseStack, this.minecraft.renderBuffers().bufferSource(), partialTick);
            }
        }
        poseStack.popPose();
        this.minecraft.renderBuffers().bufferSource().endBatch(NarrativeCraftMod.dialogBackgroundRenderType);
    }

    public void updateBobbing(float value1, float value2) {
        this.dialogEntityBobbing.setNoiseShakeSpeed(value1);
        this.dialogEntityBobbing.setNoiseShakeStrength(value2);
    }

    private Vec3 getDialogInterpolatedAppearPosition(double t) {
        Vec3 dialogPos = this.translateToRelative(this.dialogPosition);
        Vec3 dialogPositionOffsetApplied = this.translateToRelativeApplyOffset(this.dialogPosition);
        double x = Mth.lerp((double)t, (double)dialogPos.x, (double)dialogPositionOffsetApplied.x);
        double y = Mth.lerp((double)t, (double)dialogPos.y, (double)dialogPositionOffsetApplied.y);
        double z = Mth.lerp((double)t, (double)dialogPos.z, (double)dialogPositionOffsetApplied.z);
        return new Vec3(x, y, z);
    }

    private Vec3 getDialogInterpolatedDisappearPosition(double t) {
        Vec3 dialogPos = this.translateToRelative(this.dialogPosition);
        Vec3 dialogPositionOffsetApplied = this.translateToRelativeApplyOffset(this.dialogPosition);
        double x = Mth.lerp((double)t, (double)dialogPositionOffsetApplied.x, (double)dialogPos.x);
        double y = Mth.lerp((double)t, (double)dialogPositionOffsetApplied.y, (double)dialogPos.y);
        double z = Mth.lerp((double)t, (double)dialogPositionOffsetApplied.z, (double)dialogPos.z);
        return new Vec3(x, y, z);
    }

    private void renderDialogBackground(PoseStack poseStack, float partialTick) {
        MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.last().pose();
        Side side = this.dialogOffsetSide();
        double diffY = this.translateToRelativeApplyOffset((Vec3)this.dialogPosition).y - this.translateToRelative((Vec3)this.dialogPosition).y;
        float originalWidth = this.totalWidth;
        float originalHeight = this.totalHeight;
        if (this.isAnimating() && !this.dialogStarting && !this.dialogStopping) {
            originalWidth = this.getInterpolatedWidth(partialTick);
            originalHeight = this.getInterpolatedHeight(partialTick);
        } else {
            this.oldTotalWidth = this.totalWidth;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            this.oldTotalHeight = this.totalHeight;
            this.oldScale = this.scale;
        }
        switch (side.ordinal()) {
            case 0: {
                vertexConsumer.addVertex(matrix4f, -originalWidth, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, originalWidth, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, originalWidth, -originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, -originalWidth, -originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                break;
            }
            case 3: {
                if (diffY < 0.0) {
                    vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, 0.0f, originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, originalWidth * 2.0f, originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, originalWidth * 2.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    break;
                }
                if (diffY > 0.0) {
                    vertexConsumer.addVertex(matrix4f, 0.0f, -originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, originalWidth * 2.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, originalWidth * 2.0f, -originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    break;
                }
                vertexConsumer.addVertex(matrix4f, 0.0f, -originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, 0.0f, originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, originalWidth * 2.0f, originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, originalWidth * 2.0f, -originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                break;
            }
            case 2: {
                if (diffY < 0.0) {
                    vertexConsumer.addVertex(matrix4f, -originalWidth * 2.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, -originalWidth * 2.0f, originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, 0.0f, originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    break;
                }
                if (diffY > 0.0) {
                    vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, 0.0f, -originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, -originalWidth * 2.0f, -originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    vertexConsumer.addVertex(matrix4f, -originalWidth * 2.0f, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                    break;
                }
                vertexConsumer.addVertex(matrix4f, 0.0f, originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, 0.0f, -originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, -originalWidth * 2.0f, -originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, -originalWidth * 2.0f, originalHeight / 2.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                break;
            }
            case 1: {
                vertexConsumer.addVertex(matrix4f, -originalWidth, originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, originalWidth, originalHeight, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, originalWidth, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
                vertexConsumer.addVertex(matrix4f, -originalWidth, 0.0f, 0.0f).setColor(this.backgroundColor).setLight(0xF000F0);
            }
        }
    }

    private Side dialogOffsetSide() {
        Vec3 dialogPos = this.translateToRelative(this.dialogPosition);
        Vec3 dialogPosOffset = this.translateToRelativeApplyOffset(this.dialogPosition);
        double offsetX = 0.0;
        double offsetY = dialogPosOffset.y - dialogPos.y;
        Direction direction = this.minecraft.player.getDirection();
        if (direction == Direction.EAST) {
            offsetX = dialogPosOffset.z - dialogPos.z;
        } else if (direction == Direction.WEST) {
            offsetX = dialogPos.z - dialogPosOffset.z;
        } else if (direction == Direction.NORTH) {
            offsetX = dialogPosOffset.x - dialogPos.x;
        } else if (direction == Direction.SOUTH) {
            offsetX = dialogPos.x - dialogPosOffset.x;
        }
        if (offsetY >= 0.0 && offsetX >= 0.0 && offsetX <= 0.0) {
            return Side.UP;
        }
        if (offsetY <= 0.0 && offsetX >= 0.0 && offsetX <= 0.0) {
            return Side.DOWN;
        }
        if (offsetX <= 0.0) {
            return Side.LEFT;
        }
        if (offsetX >= 0.0) {
            return Side.RIGHT;
        }
        return Side.UP;
    }

    public Vec3 translateToRelative(Vec3 worldPos) {
        Vec3 camPos = this.minecraft.gameRenderer.getMainCamera().getPosition();
        return new Vec3(worldPos.x - camPos.x, worldPos.y - camPos.y, worldPos.z - camPos.z);
    }

    public Vec3 translateToRelativeApplyOffset(Vec3 position) {
        position = this.translateToRelative(position);
        double offsetX = 0.0;
        double offsetZ = 0.0;
        switch (this.minecraft.player.getDirection()) {
            case EAST: {
                offsetZ = this.dialogOffset.x;
                break;
            }
            case WEST: {
                offsetZ = -this.dialogOffset.x;
                break;
            }
            case SOUTH: {
                offsetX = -this.dialogOffset.x;
                break;
            }
            case NORTH: {
                offsetX = this.dialogOffset.x;
            }
        }
        return new Vec3(position.x + offsetX, position.y + (double)this.dialogOffset.y, position.z + offsetZ);
    }

    public CharacterRuntime getCharacterRuntime() {
        return this.characterRuntime;
    }

    public void setCharacterRuntime(CharacterRuntime characterRuntime) {
        this.characterRuntime = characterRuntime;
    }

    public Position2D getDialogOffset() {
        return this.dialogOffset;
    }

    public void setDialogOffset(Position2D dialogOffset) {
        this.dialogOffset = dialogOffset;
    }

    public Vec3 getDialogPosition() {
        return this.dialogPosition;
    }

    public Vec3 getDialogPositionWithOffset() {
        return this.dialogPosition.add((double)this.dialogOffset.x, this.dialogPosition.y, this.dialogPosition.z);
    }

    public String getCharacterName() {
        return this.characterName;
    }

    public DialogEntityBobbing getDialogEntityBobbing() {
        return this.dialogEntityBobbing;
    }

    public void setDialogEntityBobbing(DialogEntityBobbing dialogEntityBobbing) {
        this.dialogEntityBobbing = dialogEntityBobbing;
    }

    public static enum Side {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

