/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.util.Easing;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class DialogArrowSkip {
    private final double translateTime = 0.4;
    private final DialogRenderer dialogRenderer;
    private float width;
    private float height;
    private float offset;
    private float xTranslatePoint;
    private int color;
    private int currentTick;
    private int totalTick;
    private boolean isRunning = false;

    public DialogArrowSkip(DialogRenderer dialogRenderer, float width, float height, float xTranslatePoint, float offset, int color) {
        this.dialogRenderer = dialogRenderer;
        this.width = width;
        this.height = height;
        this.xTranslatePoint = xTranslatePoint;
        this.offset = offset;
        this.color = FastColor.ARGB32.color((int)204, (int)color);
        this.totalTick = 8;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.currentTick = 0;
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void tick() {
        if (this.currentTick < this.totalTick && this.isRunning) {
            ++this.currentTick;
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTick) {
        if (!this.isRunning) {
            return;
        }
        double translateX = -this.dialogRenderer.getPaddingX() * 2.0f + this.offset;
        int originalColor = this.color;
        if (this.currentTick < this.totalTick) {
            double t = Mth.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
            t = Easing.SMOOTH.interpolate(t);
            translateX = Mth.lerp((double)t, (double)(translateX + (double)this.xTranslatePoint), (double)translateX);
            double opacity = Mth.lerp((double)t, (double)0.0, (double)0.8);
            originalColor = FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.color);
        }
        poseStack.translate(translateX, 0.0, 0.0);
        this.draw(poseStack, bufferSource, originalColor);
    }

    private void draw(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int color) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.last().pose();
        float xStart = this.dialogRenderer.getTotalWidth() - this.width - this.offset;
        float xEnd = this.dialogRenderer.getTotalWidth() + this.width - this.offset;
        vertexConsumer.addVertex(matrix4f, xStart, -this.height, 0.01f).setColor(color).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, xStart, this.height, 0.01f).setColor(color).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, xEnd, 0.0f, 0.01f).setColor(color).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, xStart, -this.height, 0.01f).setColor(color).setLight(0xF000F0);
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        double translateX = 0.0;
        double opacity = this.isRunning ? 1.0 : 0.0;
        poseStack.pushPose();
        if (this.currentTick < this.totalTick) {
            double t = Mth.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
            t = Easing.SMOOTH.interpolate(t);
            translateX = Mth.lerp((double)t, (double)this.xTranslatePoint, (double)translateX);
            opacity = Mth.lerp((double)t, (double)0.0, (double)1.0);
        }
        poseStack.translate((float)translateX + this.offset, 0.0f, 0.0f);
        VertexConsumer consumer = guiGraphics.bufferSource().getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.last().pose();
        consumer.addVertex(matrix4f, -this.width, -this.height, 0.01f).setColor(FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.color));
        consumer.addVertex(matrix4f, -this.width, this.height, 0.01f).setColor(FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.color));
        consumer.addVertex(matrix4f, this.width, 0.0f, 0.01f).setColor(FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.color));
        consumer.addVertex(matrix4f, -this.width, -this.height, 0.01f).setColor(FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)this.color));
        poseStack.popPose();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOffset() {
        return this.offset;
    }

    public int getColor() {
        return this.color;
    }
}

