/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.geometric;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class DialogTail {
    private final DialogRenderer3D dialog;
    private float width;
    private float height;
    private float offset;

    public DialogTail(DialogRenderer3D dialog, float width, float height, float offset) {
        this.dialog = dialog;
        this.width = width;
        this.height = height;
        this.offset = offset;
    }

    public void render(PoseStack poseStack, float partialTick, MultiBufferSource.BufferSource bufferSource, Camera camera) {
        TailDirection tailDirection = TailDirection.TOP;
        if (this.dialog.getDialogOffset().x > 0.0f) {
            tailDirection = TailDirection.LEFT;
        } else if (this.dialog.getDialogOffset().x < 0.0f) {
            tailDirection = TailDirection.RIGHT;
        } else if (this.dialog.getDialogOffset().y > 0.0f) {
            tailDirection = TailDirection.BOTTOM;
        }
        Vec2 tailOffset = this.getTailOffset(camera);
        poseStack.pushPose();
        if (this.dialog.getDialogOffset().x != 0.0f) {
            if (this.dialog.getDialogOffset().y < 0.0f) {
                poseStack.translate(0.0f, this.height / 2.0f - this.width / 2.0f, 0.0f);
            } else if (this.dialog.getDialogOffset().y > 0.0f) {
                poseStack.translate(0.0f, -(this.height / 2.0f) + this.width / 2.0f, 0.0f);
            }
        }
        if (tailDirection == TailDirection.RIGHT || tailDirection == TailDirection.LEFT) {
            float halfHeight = this.dialog.getHeight() / 2.0f;
            float minY = -halfHeight + this.width / 2.0f;
            float maxY = halfHeight - this.width / 2.0f;
            if (this.dialog.getDialogOffset().y != 0.0f) {
                if (tailOffset.y < minY) {
                    tailDirection = TailDirection.valueOf(tailDirection.name() + "_UP_CORNER");
                } else if (tailOffset.y > maxY) {
                    tailDirection = TailDirection.valueOf(tailDirection.name() + "_DOWN_CORNER");
                }
            }
        }
        VertexConsumer vertexConsumer = bufferSource.getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.last().pose();
        float topRight = -this.width / 2.0f + this.offset;
        float topLeft = this.width / 2.0f + this.offset;
        switch (tailDirection.ordinal()) {
            case 0: {
                this.drawTailTop(matrix4f, vertexConsumer, topRight, topLeft);
                break;
            }
            case 1: {
                this.drawTailBottom(matrix4f, vertexConsumer, topRight, topLeft);
                break;
            }
            case 5: {
                this.drawTailRight(matrix4f, vertexConsumer);
                break;
            }
            case 6: {
                this.drawTailUpRightCorner(matrix4f, vertexConsumer);
                break;
            }
            case 7: {
                this.drawTailDownRightCorner(matrix4f, vertexConsumer);
                break;
            }
            case 2: {
                this.drawTailLeft(matrix4f, vertexConsumer);
                break;
            }
            case 3: {
                this.drawTailUpLeftCorner(matrix4f, vertexConsumer);
                break;
            }
            case 4: {
                this.drawTailDownLeftCorner(matrix4f, vertexConsumer);
            }
        }
        bufferSource.endBatch();
        poseStack.popPose();
    }

    public Vec2 getTailOffset(Camera camera) {
        Vec3 entityPos = this.dialog.translateToRelative(this.dialog.getDialogPosition());
        Vec3 dialogPos = this.dialog.translateToRelativeApplyOffset(this.dialog.getDialogPosition());
        Vec3 toDialog = dialogPos.subtract(entityPos);
        Vec3 camRight = new Vec3(camera.getLeftVector()).scale(-1.0);
        Vec3 camUp = new Vec3(camera.getUpVector());
        float scale = this.dialog.getScale() * 0.025f;
        return new Vec2((float)(toDialog.dot(camRight) / (double)scale), (float)(toDialog.dot(camUp) / (double)scale));
    }

    void drawTailTop(Matrix4f matrix4f, VertexConsumer vertexConsumer, float topRight, float topLeft) {
        vertexConsumer.addVertex(matrix4f, 0.0f, -this.dialog.getHeight() - this.height, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -topRight, -this.dialog.getHeight(), 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -topLeft, -this.dialog.getHeight(), 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -topRight, -this.dialog.getHeight(), 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailBottom(Matrix4f matrix4f, VertexConsumer vertexConsumer, float topRight, float topLeft) {
        vertexConsumer.addVertex(matrix4f, -topRight, 0.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -topLeft, 0.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, this.height, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -topRight, 0.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailLeft(Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        vertexConsumer.addVertex(matrix4f, -this.height, 0.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailRight(Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        vertexConsumer.addVertex(matrix4f, this.height, 0.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailUpRightCorner(Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        vertexConsumer.addVertex(matrix4f, this.height / 2.0f, -4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -this.width, -this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, this.height / 2.0f, -4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailDownRightCorner(Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        vertexConsumer.addVertex(matrix4f, this.height / 2.0f, 4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, -this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -this.width, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, this.height / 2.0f, 4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailUpLeftCorner(Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        vertexConsumer.addVertex(matrix4f, -this.height / 2.0f, -4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, 0.0f, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, this.width, -this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -this.height / 2.0f, -4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    void drawTailDownLeftCorner(Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        vertexConsumer.addVertex(matrix4f, -this.height / 2.0f, 4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, this.width, this.width / 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, this.width, -this.width * 2.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
        vertexConsumer.addVertex(matrix4f, -this.height / 2.0f, 4.0f, 0.0f).setColor(this.dialog.getBackgroundColor()).setLight(0xF000F0);
    }

    static enum TailDirection {
        TOP,
        BOTTOM,
        LEFT,
        LEFT_UP_CORNER,
        LEFT_DOWN_CORNER,
        RIGHT,
        RIGHT_UP_CORNER,
        RIGHT_DOWN_CORNER;

    }
}

