/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.interaction;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.util.Easing;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class InteractionEyeRenderer {
    private static final double APPEAR_TIME = 0.15;
    private static final float BASE_SCALE = 0.025f;
    private static final float SIZE = 10.0f;
    private static final int MAX_OPACITY = 255;
    private static int currentTick;
    private static Vec3 position;
    private static boolean isWatching;
    private static int lastEntityId;

    public static void tick() {
        int maxTick;
        if ((currentTick += isWatching ? 1 : -1) > (maxTick = 3)) {
            currentTick = maxTick;
        }
        if (currentTick < 0) {
            currentTick = 0;
        }
    }

    public static void render(PoseStack poseStack, float partialTick, int entityId) {
        Minecraft mc = Minecraft.getInstance();
        Entity entity = mc.level.getEntity(entityId);
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        boolean bl = isWatching = entity != null;
        if (entityId != -1 && lastEntityId != entityId) {
            currentTick = 0;
        }
        if (isWatching) {
            position = entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            lastEntityId = entityId;
        }
        if (position == null || currentTick == 0 && !isWatching) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(InteractionEyeRenderer.position.x - camPos.x, InteractionEyeRenderer.position.y - camPos.y, InteractionEyeRenderer.position.z - camPos.z);
        poseStack.mulPose(mc.getEntityRenderDispatcher().camera.rotation());
        int totalTick = 3;
        double t = ((double)currentTick + (isWatching ? (double)partialTick : 1.0 - (double)partialTick)) / (double)totalTick;
        t = Easing.SMOOTH.interpolate(Mth.clamp((double)t, (double)0.0, (double)1.0));
        float scale = (float)((double)0.025f * t);
        int opacity = (int)(255.0 * t);
        poseStack.scale(scale, -scale, scale);
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer vc = bufferSource.getBuffer(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f mat = poseStack.last().pose();
        vc.addVertex(mat, -10.0f, 10.0f, -1.0f).setColor(0, 0, 0, opacity);
        vc.addVertex(mat, 10.0f, 10.0f, -1.0f).setColor(0, 0, 0, opacity);
        vc.addVertex(mat, 10.0f, -10.0f, -1.0f).setColor(0, 0, 0, opacity);
        vc.addVertex(mat, -10.0f, -10.0f, -1.0f).setColor(0, 0, 0, opacity);
        Font font = mc.font;
        float f = (float)(-mc.font.width((FormattedText)ImageFontConstants.EYE_OPEN)) / 2.0f;
        Objects.requireNonNull(mc.font);
        font.drawInBatch(ImageFontConstants.EYE_OPEN, f, (float)(-9) / 2.0f, FastColor.ARGB32.color((int)opacity, (int)0xFFFFFF), false, mat, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
        poseStack.popPose();
        bufferSource.endBatch();
    }
}

