/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.playback;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.BreakBlockAction;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;

public class PlaybackData {
    private final ActionsData actionsData;
    private final Playback playback;
    private Entity entity;
    private int localTick;

    public PlaybackData(ActionsData actionsData, Playback playback) {
        this.actionsData = actionsData;
        this.localTick = 0;
        this.playback = playback;
    }

    public void tick(int globalTick) {
        if (globalTick >= this.actionsData.getSpawnTick() && this.entity == null) {
            this.spawnEntity(this.actionsData.getLocations().getFirst());
        }
        if (this.entity == null) {
            return;
        }
        List<Location> movements = this.actionsData.getLocations();
        if (this.localTick >= movements.size()) {
            return;
        }
        Location current = movements.get(this.localTick);
        Location next = this.localTick + 1 < movements.size() ? movements.get(this.localTick + 1) : current;
        this.moveEntity(current, next, false);
        ++this.localTick;
    }

    public Level getLevel() {
        return this.entity.level();
    }

    public void changeLocationByTick(int newTick, boolean seamless) {
        if (newTick >= this.actionsData.getSpawnTick()) {
            if (this.entity == null) {
                this.spawnEntity(this.actionsData.getLocations().getFirst());
            }
        } else {
            this.killEntity();
            this.reset();
            return;
        }
        this.localTick = newTick - this.actionsData.getSpawnTick();
        Location location = this.actionsData.getLocations().get(this.localTick);
        if (seamless) {
            this.moveEntity(location, location, true);
        } else {
            this.killEntity();
            this.spawnEntity(location);
        }
    }

    public void killEntity() {
        if (this.entity == null) {
            return;
        }
        NarrativeCraftMod.server.execute(() -> {
            this.entity.remove(Entity.RemovalReason.KILLED);
            Entity patt0$temp = this.entity;
            if (patt0$temp instanceof FakePlayer) {
                FakePlayer fakePlayer = (FakePlayer)patt0$temp;
                Util.removeFakePlayerUUID(fakePlayer);
            }
            this.entity = null;
        });
    }

    public void spawnEntity(Location location) {
        if (this.actionsData.getEntityId() == BuiltInRegistries.ENTITY_TYPE.getId((Object)EntityType.PLAYER)) {
            return;
        }
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.byId(this.actionsData.getEntityId());
        this.entity = Util.createEntityFromKey(entityType, (ServerLevel)this.playback.getLevel());
        if (this.entity == null) {
            return;
        }
        try {
            this.entity.load(Util.nbtFromString(this.actionsData.getNbtData()));
        }
        catch (CommandSyntaxException e) {
            NarrativeCraftMod.LOGGER.error("Unexpected error when trying to load nbt entity data! ", (Throwable)e);
            return;
        }
        Entity entity = this.entity;
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.setNoAi(true);
        }
        this.moveEntity(location, location, true);
        entity = this.entity;
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            List<Action> actions = this.playback.getMasterEntityData().getActions().stream().filter(action -> action instanceof BreakBlockAction && action.getTick() == this.playback.getTick() - 1).toList();
            boolean randomizeMotion = !actions.isEmpty();
            LivingEntity livingEntity = this.playback.getMasterEntity();
            if (livingEntity instanceof FakePlayer) {
                FakePlayer fakePlayer = (FakePlayer)livingEntity;
                this.entity = fakePlayer.drop(itemEntity.getItem(), randomizeMotion, false);
            }
        }
        this.playback.getLevel().addFreshEntity(this.entity);
    }

    private void moveEntity(Location current, Location next, boolean silent) {
        if (this.entity == null) {
            return;
        }
        this.entity.setXRot(current.pitch());
        this.entity.setYRot(current.yaw());
        this.entity.setYHeadRot(current.yaw());
        this.entity.setOnGround(current.onGround());
        this.entity.teleportTo(current.x(), current.y(), current.z());
        if (!silent) {
            this.entity.move(MoverType.SELF, Location.deltaLocation(current, next).asVec3());
        }
    }

    public void reset() {
        this.localTick = 0;
        this.actionsData.reset(this.entity);
    }

    public boolean hasEnded() {
        return this.localTick >= this.actionsData.getLocations().size();
    }

    public ActionsData getActionsData() {
        return this.actionsData;
    }

    public int getLocalTick() {
        return this.localTick;
    }

    public void setLocalTick(int localTick) {
        this.localTick = localTick;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Playback getPlayback() {
        return this.playback;
    }
}

