/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import com.mojang.datafixers.util.Pair;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemChangeAction
extends Action {
    private final int itemId;
    private final int oldItemId;
    private final String data;
    private final String oldData;
    private final String equipmentSlot;

    public ItemChangeAction(int waitTick, String equipmentSlot, ItemStack itemStack, ItemStack oldItemStack, RegistryAccess registryAccess) {
        super(waitTick, ActionType.ITEM_CHANGE);
        this.itemId = BuiltInRegistries.ITEM.getId((Object)itemStack.getItem());
        this.oldItemId = BuiltInRegistries.ITEM.getId((Object)oldItemStack.getItem());
        this.equipmentSlot = equipmentSlot;
        this.data = this.getItemComponents(itemStack, registryAccess);
        this.oldData = this.getItemComponents(oldItemStack, registryAccess);
    }

    private String getItemComponents(ItemStack itemStack, RegistryAccess registryAccess) {
        if (itemStack.isEmpty()) {
            return null;
        }
        Tag tag = Util.getItemTag(itemStack, registryAccess);
        Tag componentsTag = ((CompoundTag)tag).get("components");
        if (componentsTag != null) {
            return componentsTag.toString();
        }
        return null;
    }

    @Override
    public void execute(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.changeItem(livingEntity, this.itemId, this.data);
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.changeItem(livingEntity, this.oldItemId, this.oldData);
        }
    }

    private void changeItem(LivingEntity entity, int itemId, String data) {
        CompoundTag tag;
        Item item = (Item)BuiltInRegistries.ITEM.byId(itemId);
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (data != null && (tag = Util.tagFromIdAndComponents(item, data)) != null) {
            itemStack = Util.generateItemStackFromNBT(tag, entity.registryAccess());
        }
        entity.level().getServer().getPlayerList().broadcastAll((Packet)new ClientboundSetEquipmentPacket(entity.getId(), List.of(new Pair((Object)EquipmentSlot.valueOf((String)this.equipmentSlot), (Object)itemStack))));
        entity.setItemSlot(EquipmentSlot.valueOf((String)this.equipmentSlot), itemStack);
    }
}

