/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions.manager;

import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.recording.actions.AbstractHorseByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.BoatBubbleAction;
import fr.loudo.narrativecraft.narrative.recording.actions.BoatPaddleAction;
import fr.loudo.narrativecraft.narrative.recording.actions.EntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.ItemChangeAction;
import fr.loudo.narrativecraft.narrative.recording.actions.LivingEntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PoseAction;
import fr.loudo.narrativecraft.narrative.recording.actions.modsListeners.EmoteCraftListeners;
import fr.loudo.narrativecraft.narrative.recording.actions.modsListeners.ModsListenerImpl;
import fr.loudo.narrativecraft.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ActionDifferenceListener {
    private final List<EquipmentSlot> equipmentSlotList = Arrays.asList(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.BODY, EquipmentSlot.LEGS, EquipmentSlot.FEET);
    private final ActionsData actionsData;
    private final Recording recording;
    private Pose poseState;
    private byte entityByteState;
    private byte livingEntityByteState;
    private byte abstractHorseEntityByteState;
    private int BoatEntityBubbleState;
    private boolean BoatEntityLeftPaddleState;
    private boolean BoatEntityRightPaddleState;
    private final HashMap<EquipmentSlot, ItemStack> currentItemInEquipmentSlot;
    private List<ModsListenerImpl> modsListenerList;

    public ActionDifferenceListener(ActionsData actionsData, Recording recording) {
        this.actionsData = actionsData;
        this.currentItemInEquipmentSlot = new HashMap();
        this.recording = recording;
        this.BoatEntityLeftPaddleState = false;
        this.BoatEntityRightPaddleState = false;
        this.initItemSlot();
        this.initModsListeners();
    }

    private void initItemSlot() {
        for (EquipmentSlot equipmentSlot : this.equipmentSlotList) {
            this.currentItemInEquipmentSlot.put(equipmentSlot, new ItemStack((ItemLike)Items.AIR));
        }
    }

    private void initModsListeners() {
        this.modsListenerList = new ArrayList<ModsListenerImpl>();
        if (Services.PLATFORM.isModLoaded("emotecraft")) {
            EmoteCraftListeners emoteCraftListeners = new EmoteCraftListeners(this);
            emoteCraftListeners.start();
            this.modsListenerList.add(emoteCraftListeners);
        }
    }

    public void listenDifference() {
        if (this.actionsData.getEntity() instanceof LivingEntity) {
            this.poseListener();
            this.entityByteListener();
            this.livingEntityByteListener();
            this.itemListener();
        }
    }

    private void poseListener() {
        if (this.actionsData.getEntity().getPose() != this.poseState) {
            PoseAction action = new PoseAction(this.recording.getTick(), this.actionsData.getEntity().getPose(), this.poseState);
            this.poseState = this.actionsData.getEntity().getPose();
            this.actionsData.addAction(action);
        }
    }

    private void entityByteListener() {
        byte entityCurrentByte = (Byte)this.actionsData.getEntity().getEntityData().get(EntityAccessor.getDATA_SHARED_FLAGS_ID());
        if (this.entityByteState != entityCurrentByte) {
            EntityByteAction entityByteAction = new EntityByteAction(this.recording.getTick(), entityCurrentByte, this.entityByteState);
            this.entityByteState = entityCurrentByte;
            this.actionsData.addAction(entityByteAction);
        }
    }

    private void livingEntityByteListener() {
        byte livingEntityCurrentByte = (Byte)this.actionsData.getEntity().getEntityData().get(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS());
        if (this.livingEntityByteState != livingEntityCurrentByte) {
            LivingEntityByteAction livingEntityByteAction = new LivingEntityByteAction(this.recording.getTick(), livingEntityCurrentByte, this.livingEntityByteState);
            this.livingEntityByteState = livingEntityCurrentByte;
            this.actionsData.addAction(livingEntityByteAction);
        }
    }

    public void abstractHorseEntityByteListener(byte abstractHorseCurrentByte) {
        if (this.actionsData.getEntity() instanceof AbstractHorse && this.abstractHorseEntityByteState != abstractHorseCurrentByte) {
            AbstractHorseByteAction action = new AbstractHorseByteAction(this.recording.getTick(), abstractHorseCurrentByte, this.abstractHorseEntityByteState);
            this.abstractHorseEntityByteState = abstractHorseCurrentByte;
            this.actionsData.addAction(action);
        }
    }

    public void BoatEntityBubbleListener(int BoatCurrentBubble) {
        if (this.actionsData.getEntity() instanceof Boat && this.BoatEntityBubbleState != BoatCurrentBubble) {
            BoatBubbleAction action = new BoatBubbleAction(this.recording.getTick(), BoatCurrentBubble, this.BoatEntityBubbleState);
            this.BoatEntityBubbleState = BoatCurrentBubble;
            this.actionsData.addAction(action);
        }
    }

    public void BoatEntityPaddleListener(boolean left, boolean right) {
        if (this.actionsData.getEntity() instanceof Boat && (this.BoatEntityLeftPaddleState != left || this.BoatEntityRightPaddleState != right)) {
            BoatPaddleAction action = new BoatPaddleAction(this.recording.getTick(), left, right, this.BoatEntityLeftPaddleState, this.BoatEntityRightPaddleState);
            this.BoatEntityLeftPaddleState = left;
            this.BoatEntityRightPaddleState = right;
            this.actionsData.addAction(action);
        }
    }

    private void itemListener() {
        for (EquipmentSlot equipmentSlot : this.equipmentSlotList) {
            ItemStack itemFromSlot = this.currentItemInEquipmentSlot.get(equipmentSlot);
            ItemStack currentItemFromSlot = ((LivingEntity)this.actionsData.getEntity()).getItemBySlot(equipmentSlot);
            if (BuiltInRegistries.ITEM.getId((Object)itemFromSlot.getItem()) == BuiltInRegistries.ITEM.getId((Object)currentItemFromSlot.getItem())) continue;
            this.currentItemInEquipmentSlot.replace(equipmentSlot, currentItemFromSlot.copy());
            this.onItemChange(currentItemFromSlot, itemFromSlot, equipmentSlot, this.recording.getTick());
        }
    }

    private void onItemChange(ItemStack itemStack, ItemStack oldItemStack, EquipmentSlot equipmentSlot, int tick) {
        ItemChangeAction itemChangeAction = new ItemChangeAction(tick, equipmentSlot.name(), itemStack, oldItemStack, this.actionsData.getEntity().registryAccess());
        this.actionsData.addAction(itemChangeAction);
    }

    public Recording getRecording() {
        return this.recording;
    }

    public List<ModsListenerImpl> getModsListenerList() {
        return this.modsListenerList;
    }

    public ActionsData getActionsData() {
        return this.actionsData;
    }
}

