/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.platform.Services;
import fr.loudo.narrativecraft.util.InkUtil;
import fr.loudo.narrativecraft.util.Translation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;

public class EmoteInkAction
extends InkAction {
    private String action;
    private boolean forced;
    private KeyframeAnimation emote;
    private CharacterStory characterStory;

    public EmoteInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (!Services.PLATFORM.isModLoaded("emotecraft")) {
            return InkActionResult.ignored();
        }
        this.forced = InkUtil.getOptionalArgument(this.command, "force");
        if (arguments.size() < 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Action, play or stop"));
        }
        this.action = arguments.get(1);
        if (arguments.size() < 3) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Emote name"));
        }
        if (!this.action.equals("play") && !this.action.equals("stop")) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Only play or stop"));
        }
        String emoteName = arguments.get(2);
        this.emote = this.getEmote(emoteName, (UUIDMap<KeyframeAnimation>)UniversalEmoteSerializer.serverEmotes);
        if (this.emote == null) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", String.format("Emote %s does not exists.", emoteName)));
        }
        if (arguments.size() < 4) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Character name"));
        }
        String characterName = arguments.get(3);
        this.characterStory = NarrativeCraftMod.getInstance().getCharacterManager().getCharacterByName(characterName);
        if (this.characterStory == null) {
            this.characterStory = scene.getNpcByName(characterName);
        }
        if (this.characterStory == null) {
            return InkActionResult.error((Component)Translation.message("character.no_exists", characterName));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        this.isRunning = false;
        if (!Services.PLATFORM.isModLoaded("emotecraft")) {
            return InkActionResult.ignored();
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return InkActionResult.ignored();
        }
        List<CharacterRuntime> characterRuntimes = storyHandler.getCharacterRuntimeFromCharacter(this.characterStory);
        if (characterRuntimes.isEmpty()) {
            return InkActionResult.ignored();
        }
        for (CharacterRuntime characterRuntime : characterRuntimes) {
            if (characterRuntime == null || characterRuntime.getEntity() == null) continue;
            ServerEmoteAPI.playEmote((UUID)characterRuntime.getEntity().getUUID(), (KeyframeAnimation)this.emote, (boolean)this.forced);
        }
        return InkActionResult.ok();
    }

    private KeyframeAnimation getEmote(String id, UUIDMap<KeyframeAnimation> emotes) {
        try {
            UUID emoteID = UUID.fromString(id);
            for (KeyframeAnimation keyframeAnimation : emotes) {
                if (!keyframeAnimation.get().equals(emoteID)) continue;
                return keyframeAnimation;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (KeyframeAnimation animation : emotes) {
            String emoteName = animation.getName();
            if (!(emoteName = emoteName.replace("\"", "")).equalsIgnoreCase(id)) continue;
            return animation;
        }
        return null;
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

