/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.FadeState;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class FadeInkAction
extends InkAction {
    private double fadeInSeconds;
    private double staySeconds;
    private double fadeOutSeconds;
    private int color;
    private int totalTick;
    private FadeState currentFadeState;

    public FadeInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    public void tick() {
        if (!this.isRunning) {
            return;
        }
        ++this.tick;
        if (this.tick >= this.totalTick) {
            this.tick = 0;
            if (this.currentFadeState == FadeState.FADE_IN) {
                this.currentFadeState = FadeState.STAY;
                this.totalTick = (int)(this.staySeconds * 20.0);
            } else if (this.currentFadeState == FadeState.STAY) {
                this.currentFadeState = FadeState.FADE_OUT;
                this.totalTick = (int)(this.fadeOutSeconds * 20.0);
            } else if (this.currentFadeState == FadeState.FADE_OUT) {
                this.isRunning = false;
            }
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, float partialTick) {
        if (!this.isRunning) {
            return;
        }
        double t = Mth.clamp((double)(((float)this.tick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        int opacity = 255;
        if (this.currentFadeState == FadeState.FADE_IN) {
            opacity = (int)Mth.lerp((double)t, (double)0.0, (double)255.0);
        } else if (this.currentFadeState == FadeState.FADE_OUT) {
            opacity = (int)Mth.lerp((double)t, (double)255.0, (double)0.0);
        }
        int newColor = FastColor.ARGB32.color((int)opacity, (int)this.color);
        guiGraphics.fill(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), newColor);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade in seconds"));
        }
        try {
            this.fadeInSeconds = Double.parseDouble(arguments.get(1));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(1)));
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Stay seconds"));
        }
        try {
            this.staySeconds = Double.parseDouble(arguments.get(2));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(2)));
        }
        if (arguments.size() == 3) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Fade out seconds"));
        }
        try {
            this.fadeOutSeconds = Double.parseDouble(arguments.get(3));
        }
        catch (NumberFormatException e) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.number", arguments.get(3)));
        }
        this.color = 0;
        if (arguments.size() > 4) {
            try {
                this.color = Integer.parseInt(arguments.get(4), 16);
            }
            catch (NumberFormatException e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.color", arguments.get(4)));
            }
        }
        if (this.fadeInSeconds > 2.0) {
            this.fadeInSeconds -= 1.0;
        }
        if (this.staySeconds > 2.0) {
            this.staySeconds -= 1.0;
        }
        if (this.fadeOutSeconds > 2.0) {
            this.fadeOutSeconds -= 1.0;
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        this.currentFadeState = FadeState.FADE_IN;
        this.totalTick = (int)(this.fadeInSeconds * 20.0);
        if (this.fadeInSeconds == 0.0 && this.staySeconds == 0.0 && this.fadeOutSeconds == 0.0) {
            playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof FadeInkAction);
        }
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

