/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class InteractionInkAction
extends InkAction {
    private String action;
    private Interaction interaction;

    public InteractionInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Action type [summon/remove]"));
        }
        this.action = arguments.get(1);
        if (!this.action.equals("summon") && !this.action.equals("remove")) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Only action type [summon/remove]"));
        }
        if (arguments.size() == 2) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "Interaction name"));
        }
        this.interaction = scene.getInteractionByName(arguments.get(2));
        if (this.interaction == null) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", Translation.message("interaction.no_exists", arguments.get(2), scene.getName())));
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        if (this.action.equals("summon")) {
            InteractionController controller = new InteractionController(Environment.PRODUCTION, (Player)playerSession.getPlayer(), this.interaction);
            controller.startSession();
            playerSession.setController(null);
            playerSession.getInteractionControllers().add(controller);
        } else if (this.action.equals("remove")) {
            for (InteractionController interactionController2 : playerSession.getInteractionControllers()) {
                if (!interactionController2.getInteraction().getName().equalsIgnoreCase(this.interaction.getName())) continue;
                interactionController2.stopSession(false);
            }
            playerSession.getInteractionControllers().removeIf(interactionController -> interactionController.getInteraction().getName().equalsIgnoreCase(this.interaction.getName()));
            for (InkAction inkAction : playerSession.getInkActions()) {
                if (!(inkAction instanceof InteractionInkAction)) continue;
                inkAction.setRunning(false);
            }
            this.isRunning = false;
        }
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return true;
    }
}

