/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.narrative.character.MainCharacterAttribute;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CharacterAdvancedScreen
extends Screen {
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen lastScreen;
    private final MainCharacterAttribute mainCharacterAttribute;
    private final CharacterStory characterStory;

    public CharacterAdvancedScreen(Screen lastScreen, CharacterStory characterStory) {
        super((Component)Component.literal((String)"Character Advanced Screen"));
        this.lastScreen = lastScreen;
        this.characterStory = characterStory;
        this.mainCharacterAttribute = characterStory.getMainCharacterAttribute();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void init() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical().spacing(5));
        if (this.mainCharacterAttribute != null && this.characterStory.getCharacterType() == CharacterType.MAIN) {
            MutableComponent skinShowBtnComponent = this.mainCharacterAttribute.isSameSkinAsTheir() ? Translation.message("screen.character_advanced.player_same_skin_as_their", new Object[0]) : (this.mainCharacterAttribute.isSameSkinAsPlayer() ? Translation.message("screen.character_advanced.same_skin_as_player", new Object[0]) : Translation.message("screen.character_advanced.skin_from_folder", new Object[0]));
            Button skinShowBtn = Button.builder((Component)skinShowBtnComponent, button -> {
                Component newMode = button.getMessage();
                if (newMode.equals((Object)Translation.message("screen.character_advanced.skin_from_folder", new Object[0]))) {
                    button.setMessage((Component)Translation.message("screen.character_advanced.same_skin_as_player", new Object[0]));
                    this.mainCharacterAttribute.setSameSkinAsPlayer(true);
                    this.mainCharacterAttribute.setSameSkinAsTheir(false);
                } else if (newMode.equals((Object)Translation.message("screen.character_advanced.same_skin_as_player", new Object[0]))) {
                    button.setMessage((Component)Translation.message("screen.character_advanced.player_same_skin_as_their", new Object[0]));
                    this.mainCharacterAttribute.setSameSkinAsPlayer(false);
                    this.mainCharacterAttribute.setSameSkinAsTheir(true);
                } else {
                    button.setMessage((Component)Translation.message("screen.character_advanced.skin_from_folder", new Object[0]));
                    this.mainCharacterAttribute.setSameSkinAsPlayer(false);
                    this.mainCharacterAttribute.setSameSkinAsTheir(false);
                }
            }).width(200).build();
            skinShowBtn.active = this.mainCharacterAttribute.isMainCharacter();
            Checkbox mainCharacterCheck = Checkbox.builder((Component)Translation.message("screen.character_advanced.main_character", new Object[0]), (Font)this.minecraft.font).onValueChange((checkbox, b) -> {
                this.mainCharacterAttribute.setMainCharacter(b);
                skinShowBtn.active = b;
            }).selected(this.mainCharacterAttribute.isMainCharacter()).build();
            linearLayout.addChild((LayoutElement)skinShowBtn);
            linearLayout.addChild((LayoutElement)mainCharacterCheck);
        }
        Checkbox showNametagCheckBox = Checkbox.builder((Component)Translation.message("screen.character_advanced.show_nametag", new Object[0]), (Font)this.minecraft.font).onValueChange((checkbox, b) -> this.characterStory.setShowNametag(b)).selected(this.characterStory.showNametag()).build();
        linearLayout.addChild((LayoutElement)showNametagCheckBox);
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(200).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }
}

