/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;

public class CharacterEntityTypeScreen
extends OptionsSubScreen {
    private EntityTypeList entityTypeList;
    private final List<EntityType<?>> entityTypes = NarrativeCraftMod.getInstance().getCharacterManager().getAvailableEntityTypes();
    private final CharacterStory characterStory;
    private final Scene scene;

    public CharacterEntityTypeScreen(Screen lastScreen, CharacterStory characterStory, Scene scene) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Component.literal((String)"Change Character Entity Type"));
        this.characterStory = characterStory;
        this.scene = scene;
    }

    protected void addTitle() {
        LinearLayout linearlayout = ((LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.horizontal())).spacing(8);
        linearlayout.defaultCellSetting().alignVerticallyMiddle();
        linearlayout.addChild((LayoutElement)new StringWidget(this.title, this.font));
    }

    protected void addContents() {
        this.entityTypeList = (EntityTypeList)this.layout.addToContents((LayoutElement)new EntityTypeList(this.minecraft));
    }

    protected void repositionElements() {
        super.repositionElements();
        this.entityTypeList.updateSize(this.width, this.layout);
    }

    public void onClose() {
        EntityTypeList.Entry entry = (EntityTypeList.Entry)this.entityTypeList.getSelected();
        if (entry == null) {
            this.minecraft.setScreen(null);
            return;
        }
        EntityType<?> entityType = entry.entityType;
        this.minecraft.setScreen(this.lastScreen);
        this.characterStory.updateEntityType(entityType, this.scene);
    }

    protected void addOptions() {
    }

    class EntityTypeList
    extends ObjectSelectionList<Entry> {
        public EntityTypeList(Minecraft minecraft) {
            super(minecraft, CharacterEntityTypeScreen.this.width, CharacterEntityTypeScreen.this.height - 33 - 53, 33, 18);
            int selectedEntityTypeId = CharacterEntityTypeScreen.this.characterStory.getEntityTypeId();
            CharacterEntityTypeScreen.this.entityTypes.forEach(entityType -> {
                Entry entry = new Entry((EntityType<?>)entityType);
                this.addEntry((AbstractSelectionList.Entry)entry);
                if (selectedEntityTypeId == BuiltInRegistries.ENTITY_TYPE.getId(entityType)) {
                    this.setSelected((AbstractSelectionList.Entry)entry);
                }
            });
            if (this.getSelected() != null) {
                this.centerScrollOn((AbstractSelectionList.Entry)((Entry)this.getSelected()));
            }
        }

        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final EntityType<?> entityType;

            public Entry(EntityType<?> entityType) {
                this.entityType = entityType;
            }

            public void render(GuiGraphics p_345300_, int p_345469_, int p_345328_, int p_345700_, int p_345311_, int p_345185_, int p_344805_, int p_345963_, boolean p_345912_, float p_346091_) {
                p_345300_.drawCenteredString(CharacterEntityTypeScreen.this.font, this.entityType.getDescription().getString().toUpperCase(), EntityTypeList.this.width / 2, p_345328_ + p_345185_ / 2 - 4, -1);
            }

            public boolean keyPressed(int p_346403_, int p_345881_, int p_345858_) {
                if (CommonInputs.selected((int)p_346403_)) {
                    this.select();
                    CharacterEntityTypeScreen.this.onClose();
                    return true;
                }
                return super.keyPressed(p_346403_, p_345881_, p_345858_);
            }

            public boolean mouseClicked(double p_344965_, double p_345385_, int p_345080_) {
                this.select();
                return super.mouseClicked(p_344965_, p_345385_, p_345080_);
            }

            private void select() {
                EntityTypeList.this.setSelected((AbstractSelectionList.Entry)this);
            }

            public Component getNarration() {
                return Component.literal((String)CharacterEntityTypeScreen.this.characterStory.getName());
            }
        }
    }
}

