/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class EditInfoScreen<T extends NarrativeEntry>
extends Screen {
    public final int WIDGET_WIDTH = 190;
    public final int EDIT_BOX_NAME_HEIGHT = 20;
    public final int EDIT_BOX_DESCRIPTION_HEIGHT = 90;
    public final int BUTTON_HEIGHT = 20;
    public final int GAP = 5;
    protected String name;
    protected String description;
    protected Button actionButton;
    protected Button backButton;
    protected ScreenUtils.LabelBox nameBox;
    protected ScreenUtils.MultilineLabelBox descriptionBox;
    protected StringWidget titleWidget;
    protected Screen lastScreen;
    protected T narrativeEntry;
    protected EditScreenAdapter<T> adapter;
    public Map<String, Object> extraFields = new HashMap<String, Object>();
    public List<String> descriptionPlaceholders = List.of("Once upon a time... In a wild... wild world...", "Until then is the reason this mod exists!", "Free palestine", "You should try narrative games", "Play Outer Wilds", "This screen was boring to code.", "I'm sure your creating a wonderful story!", "Your gender is valid!", "Easter egg message! No just kidding, not rare at all...", "Play Until Then", "Play Life Is Strange (NOT Double Exposure)", "Do these placeholders have a meaning anymore?", "Watch Frieren!", "Play Signalis", "The pain of your absence is sharp and haunting\nAnd i would give anything not to know it; anything but never knowing you at all, which would be worse", "The amazing digital circus is the best animation out there");

    public EditInfoScreen(Screen lastScreen, T narrativeEntry, EditScreenAdapter<T> adapter) {
        super((Component)Component.literal((String)"Edit info"));
        this.name = narrativeEntry != null ? ((NarrativeEntry)narrativeEntry).getName() : "";
        this.description = narrativeEntry != null ? ((NarrativeEntry)narrativeEntry).getDescription() : "";
        this.lastScreen = lastScreen;
        this.narrativeEntry = narrativeEntry;
        this.adapter = adapter;
    }

    protected void init() {
        this.extraFields.clear();
        MutableComponent title = Component.empty();
        int titleX = this.width / 2 - this.font.width((FormattedText)title) / 2;
        Objects.requireNonNull(this.font);
        int labelHeight = 9 + 5;
        int centerX = this.width / 2 - 95;
        int centerY = this.height / 2 - (labelHeight + 25 + labelHeight + 90 + 40) / 2;
        if (this.adapter != null) {
            this.adapter.initExtraFields(this, this.narrativeEntry);
            for (Object object : this.extraFields.values()) {
                if (!(object instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)object;
                centerY -= widget.getHeight() - 5;
            }
        }
        this.titleWidget = ScreenUtils.text((Component)title, this.font, titleX, centerY - labelHeight);
        this.addRenderableWidget(this.titleWidget);
        MutableComponent nameLabel = Translation.message("global.name", new Object[0]).append((Component)Component.literal((String)" *").withStyle(style -> style.withColor(ChatFormatting.RED)));
        this.nameBox = new ScreenUtils.LabelBox((Component)nameLabel, this.font, 190, 20, centerX, centerY, ScreenUtils.Align.VERTICAL);
        this.nameBox.getEditBox().setValue(this.name);
        this.nameBox.getEditBox().setFilter(text -> text.matches("[a-zA-Z0-9 _-]*"));
        this.addRenderableWidget(this.nameBox.getStringWidget());
        this.addRenderableWidget(this.nameBox.getEditBox());
        this.descriptionBox = new ScreenUtils.MultilineLabelBox((Component)Translation.message("global.description", new Object[0]), this.font, 190, 90, centerX, centerY += labelHeight + 20 + 5, (Component)Component.literal((String)this.descriptionPlaceholders.get(new Random().nextInt(0, this.descriptionPlaceholders.size()))));
        this.descriptionBox.getMultiLineEditBox().setValue(this.description);
        this.addRenderableWidget(this.descriptionBox.getStringWidget());
        this.addRenderableWidget(this.descriptionBox.getMultiLineEditBox());
        this.adapter.renderExtraFields(this, this.narrativeEntry, centerX, centerY += labelHeight + 90 + 5);
        for (Object object : this.extraFields.values()) {
            if (!(object instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)object;
            centerY += widget.getHeight() + 5;
        }
        MutableComponent mutableComponent = this.narrativeEntry == null ? Translation.message("global.add", new Object[0]) : Translation.message("global.update", new Object[0]);
        this.actionButton = Button.builder((Component)mutableComponent, button -> {
            if (this.nameBox.getEditBox().getValue().isEmpty()) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("screen.edit_info.name_must", new Object[0]));
                return;
            }
            this.adapter.buildFromScreen(this, this.extraFields, this.minecraft, this.narrativeEntry, this.nameBox.getEditBox().getValue(), this.descriptionBox.getMultiLineEditBox().getValue());
        }).bounds(centerX, centerY, 190, 20).build();
        this.addRenderableWidget(this.actionButton);
        this.backButton = Button.builder((Component)CommonComponents.GUI_BACK, button -> this.minecraft.setScreen(this.lastScreen)).bounds(centerX, centerY += 25, 190, 20).build();
        this.addRenderableWidget(this.backButton);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScreenUtils.LabelBox getNameBox() {
        return this.nameBox;
    }

    public ScreenUtils.MultilineLabelBox getDescriptionBox() {
        return this.descriptionBox;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public Font getFont() {
        return this.minecraft.font;
    }
}

