/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.screens.components.ButtonListScreen;
import fr.loudo.narrativecraft.screens.components.EntryBoxScreen;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class InteractionOptionScreen
extends ButtonListScreen {
    private final EntityInteraction entityInteraction;
    private final InteractionController controller;

    public InteractionOptionScreen(Screen lastScreen, EntityInteraction entityInteraction, InteractionController controller) {
        super(lastScreen, (Component)Component.literal((String)"Interaction option screen"));
        this.entityInteraction = entityInteraction;
        this.controller = controller;
    }

    @Override
    protected void addContents() {
        Button changeStitch = Button.builder((Component)Translation.message("controller.interaction.change_stitch", new Object[0]), button -> {
            EntryBoxScreen screen = new EntryBoxScreen(this, (Component)Translation.message("global.stitch", new Object[0]), this.entityInteraction.getStitch(), this.entityInteraction::setStitch);
            this.minecraft.setScreen((Screen)screen);
        }).build();
        this.objectListScreen.addButton((AbstractWidget)changeStitch);
        Button removeCharacterButton = Button.builder((Component)Translation.message("global.remove", new Object[0]), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> {
                        this.entityInteraction.kill(this.controller.getPlayerSession().getPlayer());
                        this.controller.getEntityInteractions().remove(this.entityInteraction);
                    });
                }
                this.minecraft.setScreen(null);
            }, (Component)Component.literal((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirm);
        }).build();
        this.objectListScreen.addButton((AbstractWidget)removeCharacterButton);
    }
}

