/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.interaction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.CharacterInteraction;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.EntityInteraction;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.screens.components.EntryBoxScreen;
import fr.loudo.narrativecraft.screens.storyManager.areaTrigger.AreaTriggersScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class InteractionControllerScreen
extends Screen {
    private final int BUTTON_HEIGHT = 20;
    private final int BUTTON_WIDTH = 30;
    private final InteractionController controller;

    public InteractionControllerScreen(InteractionController controller) {
        super((Component)Component.literal((String)"Interaction Controller Screen"));
        this.controller = controller;
    }

    protected void init() {
        int spacing = 5;
        int totalWidth = 150 + spacing * 3;
        int startX = (this.width - totalWidth) / 2;
        int y = this.height - 50;
        Button addCharacter = Button.builder((Component)ImageFontConstants.CHARACTER_ADD, button -> {
            ChooseCharacterScreen screen = new ChooseCharacterScreen((Screen)this, Translation.message("controller.add_character", this.controller.getInteraction().getName()).getString(), null, this.controller.getInteraction().getScene(), characterStory -> {
                if (characterStory == null) {
                    this.onClose();
                    return;
                }
                Location location = this.controller.getPlayerSession().getPlayerPosition();
                CharacterStoryData characterStoryData = new CharacterStoryData((CharacterStory)characterStory, location, true, this.controller.getInteraction().getScene());
                characterStoryData.setItems((LivingEntity)this.minecraft.player);
                characterStoryData.setEntityByte((Byte)this.minecraft.player.getEntityData().get(EntityAccessor.getDATA_SHARED_FLAGS_ID()));
                characterStoryData.setLivingEntityByte((Byte)this.minecraft.player.getEntityData().get(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS()));
                characterStoryData.spawn(this.controller.getPlayerSession().getPlayer().level(), Environment.DEVELOPMENT);
                this.controller.getCharacterStoryDataList().add(characterStoryData);
                this.minecraft.setScreen(null);
                this.controller.getPlayerSession().getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
                CharacterInteraction characterInteraction = new CharacterInteraction("", characterStoryData);
                EntryBoxScreen screen1 = new EntryBoxScreen(null, (Component)Translation.message("global.stitch", new Object[0]), characterInteraction::setStitch);
                this.controller.getCharacterInteractions().add(characterInteraction);
                this.minecraft.setScreen((Screen)screen1);
            });
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX, y, 30, 20).build();
        addCharacter.setTooltip(Tooltip.create((Component)Translation.message("tooltip.add_character", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addCharacter);
        Button addEntityInteractionBtn = Button.builder((Component)ImageFontConstants.EYE_OPEN, button -> {
            EntryBoxScreen screen = new EntryBoxScreen(this, (Component)Translation.message("global.stitch", new Object[0]), s -> {
                Vec3 position = this.controller.getPlayerSession().getPlayerPosition().asVec3();
                EntityInteraction entityInteraction = new EntityInteraction((String)s, position);
                this.controller.getEntityInteractions().add(entityInteraction);
                entityInteraction.spawn(this.controller.getPlayerSession().getPlayer(), this.controller.getEnvironment());
            });
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX + (30 + spacing) * 1, y, 30, 20).build();
        addEntityInteractionBtn.setTooltip(Tooltip.create((Component)Translation.message("controller.interaction.add_entity_interaction", new Object[0])));
        this.addRenderableWidget((GuiEventListener)addEntityInteractionBtn);
        Button areaTriggerMode = Button.builder((Component)ImageFontConstants.BOX, button -> {
            AreaTriggersScreen screen = new AreaTriggersScreen(this, this.controller);
            this.minecraft.setScreen((Screen)screen);
        }).bounds(startX + (30 + spacing) * 2, y, 30, 20).build();
        areaTriggerMode.setTooltip(Tooltip.create((Component)Translation.message("controller.interaction.area_trigger_list", new Object[0])));
        this.addRenderableWidget((GuiEventListener)areaTriggerMode);
        Button saveButton = Button.builder((Component)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.controller.stopSession(true));
            this.onClose();
        }).bounds(startX + (30 + spacing) * 3, y, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)saveButton);
        Button closeButton = Button.builder((Component)Component.literal((String)"\u2716"), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.controller.stopSession(false));
                    this.onClose();
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.literal((String)""), (Component)Translation.message("controller.confirm_leaving", new Object[0]), CommonComponents.GUI_YES, CommonComponents.GUI_CANCEL);
            this.minecraft.setScreen((Screen)confirm);
        }).bounds(startX + (30 + spacing) * 4, y, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)closeButton);
    }

    protected void renderBlurredBackground(float partialTick) {
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean isPauseScreen() {
        return false;
    }
}

