/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.mainScreen;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.options.NarrativeClientOption;
import fr.loudo.narrativecraft.screens.credits.CreditScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.Component;

public class MainScreenOptionsScreen
extends OptionsSubScreen {
    private final NarrativeClientOption option = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
    private final PlayerSession playerSession;
    private float textSpeed;
    private Checkbox autoSkipCheck;

    public MainScreenOptionsScreen(PlayerSession playerSession, Screen lastScreen) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Component.literal((String)""));
        this.playerSession = playerSession;
        this.textSpeed = this.option.textSpeed;
    }

    public void onClose() {
        this.option.textSpeed = this.textSpeed;
        if (this.playerSession.getDialogRenderer() != null) {
            this.playerSession.getDialogRenderer().getDialogScrollText().setTextSpeed(this.textSpeed);
        }
        this.option.autoSkip = this.autoSkipCheck.selected();
        NarrativeCraftFile.updateUserOptions(this.option);
        this.minecraft.setScreen(this.lastScreen);
    }

    private double textSpeedToSlider(double textSpeed) {
        double visualMin = 0.1;
        double visualMax = 10.0;
        double internalMin = 0.05;
        double internalMax = 4.0;
        return visualMin + (internalMax - textSpeed) * (visualMax - visualMin) / (internalMax - internalMin);
    }

    protected void addContents() {
        NarrativeClientOption clientOption = NarrativeCraftMod.getInstance().getNarrativeClientOptions();
        LinearLayout linearlayout = ((LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical())).spacing(8);
        AbstractSliderButton abstractSliderButton = new AbstractSliderButton(50, 20, 200, 20, (Component)Translation.message("screen.main_screen.options.dialog_speed", String.format(Locale.US, "%.2f", this.textSpeedToSlider(clientOption.textSpeed))), this.textSpeedToSlider(clientOption.textSpeed) / 10.0){

            protected void updateMessage() {
                double visualSpeed = 0.1 + this.value * 9.9;
                this.setMessage((Component)Translation.message("screen.main_screen.options.dialog_speed", String.format("%.2f", visualSpeed)));
            }

            protected void applyValue() {
                double visualSpeed = 0.1 + this.value * 9.9;
                double internalSpeed = 0.05 + (10.0 - visualSpeed) / 9.9 * 3.95;
                MainScreenOptionsScreen.this.textSpeed = (float)internalSpeed;
            }
        };
        linearlayout.addChild((LayoutElement)abstractSliderButton);
        this.autoSkipCheck = Checkbox.builder((Component)Translation.message("screen.main_screen.options.auto_skip", new Object[0]), (Font)this.minecraft.font).selected(clientOption.autoSkip).build();
        linearlayout.addChild((LayoutElement)this.autoSkipCheck);
        linearlayout.addChild((LayoutElement)Button.builder((Component)Translation.message("screen.main_screen.minecraft_options", new Object[0]), button -> {
            OptionsScreen screen = new OptionsScreen((Screen)this, this.minecraft.options);
            this.minecraft.setScreen((Screen)screen);
        }).width(200).build());
        StoryHandler storyHandler = this.playerSession.getStoryHandler();
        if (storyHandler == null || !storyHandler.isRunning()) {
            linearlayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"Credits"), button -> {
                CreditScreen creditScreen = new CreditScreen(this.playerSession, true, false);
                this.minecraft.setScreen((Screen)creditScreen);
            }).width(200).build());
        }
    }

    protected void addOptions() {
    }
}

