/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.areaTrigger;

import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.controller.areaTrigger.AreaTriggerControllerScreen;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.areaTrigger.EditScreenAreaTriggerAdapter;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;

public class AreaTriggersScreen
extends StoryElementScreen {
    private final Screen lastScreen;
    private final InteractionController interactionController;

    public AreaTriggersScreen(Screen lastScreen, InteractionController interactionController) {
        super((Component)Translation.message("controller.interaction.area_trigger_list", interactionController.getInteraction().getName()));
        this.lastScreen = lastScreen;
        this.interactionController = interactionController;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<AreaTrigger> screen = new EditInfoScreen<AreaTrigger>(this, null, new EditScreenAreaTriggerAdapter(this.lastScreen, this.interactionController));
            this.minecraft.setScreen(screen);
        });
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.interactionController.getAreaTriggers().stream().map(areaTrigger -> {
            Button button = Button.builder((Component)Component.literal((String)areaTrigger.getName()), button1 -> {
                this.interactionController.setAreaTriggerEditing((AreaTrigger)areaTrigger);
                Vec3 oldLoc1 = new Vec3(areaTrigger.getPosition1().x, areaTrigger.getPosition1().y, areaTrigger.getPosition1().z);
                Vec3 oldLoc2 = new Vec3(areaTrigger.getPosition2().x, areaTrigger.getPosition2().y, areaTrigger.getPosition2().z);
                AreaTriggerControllerScreen screen = new AreaTriggerControllerScreen(this.interactionController, (AreaTrigger)areaTrigger, oldLoc1, oldLoc2);
                this.minecraft.setScreen((Screen)screen);
            }).build();
            return new StoryElementList.StoryEntryData(button, () -> this.minecraft.setScreen(new EditInfoScreen<AreaTrigger>(this, (AreaTrigger)areaTrigger, new EditScreenAreaTriggerAdapter(this.lastScreen, this.interactionController))), () -> {
                this.interactionController.getAreaTriggers().remove(areaTrigger);
                this.minecraft.setScreen((Screen)new AreaTriggersScreen(this.lastScreen, this.interactionController));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    @Override
    protected void openFolder() {
    }
}

