/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.areaTrigger;

import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.AreaTrigger;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.areaTrigger.AreaTriggersScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class EditScreenAreaTriggerAdapter
implements EditScreenAdapter<AreaTrigger> {
    private final Screen lastScreen;
    private final Interaction interaction;
    private final InteractionController interactionController;

    public EditScreenAreaTriggerAdapter(Screen lastScreen, InteractionController interactionController) {
        this.lastScreen = lastScreen;
        this.interaction = interactionController.getInteraction();
        this.interactionController = interactionController;
    }

    @Override
    public void initExtraFields(EditInfoScreen<AreaTrigger> screen, AreaTrigger entry) {
        ScreenUtils.LabelBox stitch = new ScreenUtils.LabelBox((Component)Translation.message("global.stitch", new Object[0]), EditScreenAreaTriggerAdapter.minecraft.font, 110, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
        screen.extraFields.put("stitchBox", stitch.getEditBox());
        screen.extraFields.put("stitch", stitch);
        Checkbox isUniqueBox = Checkbox.builder((Component)Translation.message("screen.story_manager.area_trigger.is_unique", new Object[0]), (Font)EditScreenAreaTriggerAdapter.minecraft.font).selected(entry != null && entry.isUnique()).build();
        isUniqueBox.setTooltip(Tooltip.create((Component)Translation.message("tooltip.area_trigger.is_unique_explanation", new Object[0])));
        screen.extraFields.put("uniqueBox", isUniqueBox);
    }

    @Override
    public void renderExtraFields(EditInfoScreen<AreaTrigger> screen, AreaTrigger entry, int x, int y) {
        ScreenUtils.LabelBox stitch = (ScreenUtils.LabelBox)screen.extraFields.get("stitch");
        screen.addRenderableWidget((AreaTrigger)stitch.getStringWidget());
        screen.addRenderableWidget((AreaTrigger)stitch.getEditBox());
        stitch.setPosition(x, y);
        if (entry != null) {
            stitch.getEditBox().setValue(entry.getStitch());
        }
        Checkbox isUniqueBox = (Checkbox)screen.extraFields.get("uniqueBox");
        screen.addRenderableWidget((AreaTrigger)isUniqueBox);
        isUniqueBox.setPosition(x, y += stitch.getEditBox().getHeight() + screen.GAP);
    }

    @Override
    public void buildFromScreen(Screen screen, Map<String, Object> extraFields, Minecraft minecraft, @Nullable AreaTrigger existing, String name, String description) {
        ScreenUtils.LabelBox stitch = (ScreenUtils.LabelBox)extraFields.get("stitch");
        Checkbox isUniqueBox = (Checkbox)extraFields.get("uniqueBox");
        if (existing == null) {
            if (this.interactionController.areaTriggerExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("interaction.area_trigger.already_exists", name, this.interaction.getName()));
                return;
            }
            AreaTrigger areaTrigger = new AreaTrigger(name, description, this.interaction.getScene(), stitch.getEditBox().getValue(), isUniqueBox.selected());
            this.interactionController.getAreaTriggers().add(areaTrigger);
        } else {
            existing.setName(name);
            existing.setDescription(description);
            existing.setStitch(stitch.getEditBox().getValue());
            existing.setUnique(isUniqueBox.selected());
        }
        minecraft.setScreen((Screen)new AreaTriggersScreen(this.lastScreen, this.interactionController));
    }
}

