/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.interaction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.interaction.InteractionController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.interaction.Interaction;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.interaction.EditScreenInteractionAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class InteractionsScreen
extends StoryElementScreen {
    private final Scene scene;

    public InteractionsScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.interaction_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<Interaction> screen = new EditInfoScreen<Interaction>(this, null, new EditScreenInteractionAdapter(this.scene));
            this.minecraft.setScreen(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.addToFooter((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(200).build());
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getInteractions().stream().map(interaction -> {
            Button button = Button.builder((Component)Component.literal((String)interaction.getName()), button1 -> {
                NarrativeCraftMod.server.execute(() -> new InteractionController(Environment.DEVELOPMENT, (Player)this.minecraft.player, (Interaction)interaction).startSession());
                this.minecraft.setScreen(null);
            }).build();
            return new StoryElementList.StoryEntryData(button, () -> this.minecraft.setScreen(new EditInfoScreen<Interaction>(this, (Interaction)interaction, new EditScreenInteractionAdapter(this.scene))), () -> {
                try {
                    this.scene.removeInteraction((Interaction)interaction);
                    NarrativeCraftFile.updateInteractionsFile(this.scene);
                }
                catch (Exception e) {
                    this.scene.addInteraction((Interaction)interaction);
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                }
                this.minecraft.setScreen((Screen)new InteractionsScreen(this.scene));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.getSceneFolder(this.scene).toPath());
    }
}

