/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenSceneAdapter
implements EditScreenAdapter<Scene> {
    private final Chapter chapter;

    public EditScreenSceneAdapter(Chapter chapter) {
        this.chapter = chapter;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Scene> screen, Scene entry) {
        if (entry == null) {
            return;
        }
        MutableComponent mutableComponent = Translation.message("scene.rank", new Object[0]);
        Font font = screen.getFont();
        Objects.requireNonNull(screen);
        ScreenUtils.LabelBox rankBox = new ScreenUtils.LabelBox((Component)mutableComponent, font, 40, 20, 0, 0, ScreenUtils.Align.HORIZONTAL);
        rankBox.getEditBox().setFilter(string -> string.matches("^\\d*$"));
        rankBox.getEditBox().setValue(String.valueOf(entry.getRank()));
        screen.extraFields.putIfAbsent("rank", rankBox);
        screen.extraFields.putIfAbsent("rankEditBox", rankBox.getEditBox());
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Scene> screen, Scene entry, int x, int y) {
        if (entry == null) {
            return;
        }
        ScreenUtils.LabelBox labelBox = (ScreenUtils.LabelBox)screen.extraFields.get("rank");
        labelBox.setPosition(x, y);
        screen.addRenderableWidget((Scene)labelBox.getStringWidget());
        screen.addRenderableWidget((Scene)labelBox.getEditBox());
    }

    @Override
    public void buildFromScreen(Screen screen, Map<String, Object> extraFields, Minecraft minecraft, @Nullable Scene existing, String name, String description) {
        if (existing == null) {
            if (this.chapter.sceneExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("scene.already_exists", name, this.chapter.getIndex()));
                return;
            }
            Scene scene = new Scene(name, description, this.chapter);
            try {
                NarrativeCraftFile.createSceneFolder(scene);
                this.chapter.addScene(scene);
                NarrativeCraftFile.updateInkIncludes();
                minecraft.setScreen((Screen)new ScenesScreen(this.chapter));
            }
            catch (Exception e) {
                this.chapter.removeScene(scene);
                Util.sendCrashMessage((Player)minecraft.player, e);
                minecraft.setScreen(null);
            }
        } else {
            Scene newScene = new Scene(name, description, this.chapter);
            newScene.setRank(existing.getRank());
            Scene oldScene = new Scene(existing.getName(), existing.getDescription(), this.chapter);
            oldScene.setRank(existing.getRank());
            try {
                ScreenUtils.LabelBox labelBox = (ScreenUtils.LabelBox)extraFields.get("rank");
                EditBox editBox = labelBox.getEditBox();
                int rank = 1;
                if (!editBox.getValue().isEmpty()) {
                    rank = Integer.parseInt(editBox.getValue());
                }
                if (rank > this.chapter.getScenes().size()) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("scene.rank_above_scenes_size", new Object[0]));
                    return;
                }
                if (rank < 1) {
                    ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("scene.rank_no_under_one", new Object[0]));
                    return;
                }
                NarrativeCraftFile.updateSceneData(oldScene, newScene);
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateSceneNameScript(oldScene, newScene);
                if (existing.getRank() != rank) {
                    this.chapter.setSceneRank(existing, rank);
                    NarrativeCraftFile.updateSceneRankData(this.chapter);
                }
                NarrativeCraftFile.updateMasterSceneKnot(existing);
                NarrativeCraftFile.updateInkIncludes();
                minecraft.setScreen((Screen)new ScenesScreen(this.chapter));
            }
            catch (Exception e) {
                existing.setName(oldScene.getName());
                existing.setDescription(oldScene.getDescription());
                this.chapter.setSceneRank(existing, oldScene.getRank());
                Util.sendCrashMessage((Player)minecraft.player, e);
                minecraft.setScreen(null);
            }
        }
    }
}

