/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.subscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.storyManager.EditScreenAdapter;
import fr.loudo.narrativecraft.screens.storyManager.subscene.SubscenesScreen;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class EditScreenSubsceneAdapter
implements EditScreenAdapter<Subscene> {
    private final Scene scene;

    public EditScreenSubsceneAdapter(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void initExtraFields(EditInfoScreen<Subscene> screen, Subscene entry) {
    }

    @Override
    public void renderExtraFields(EditInfoScreen<Subscene> screen, Subscene entry, int x, int y) {
    }

    @Override
    public void buildFromScreen(Screen screen, Map<String, Object> extraFields, Minecraft minecraft, @Nullable Subscene existing, String name, String description) {
        if (existing == null) {
            if (this.scene.subsceneExists(name)) {
                ScreenUtils.sendToast((Component)Translation.message("global.error", new Object[0]), (Component)Translation.message("subscene.already_exists", name, this.scene.getName()));
                return;
            }
            Subscene subscene = new Subscene(name, description, this.scene);
            try {
                this.scene.addSubscene(subscene);
                NarrativeCraftFile.updateSubsceneFile(this.scene);
                minecraft.setScreen((Screen)new SubscenesScreen(this.scene));
            }
            catch (Exception e) {
                this.scene.removeSubscene(subscene);
                Util.sendCrashMessage((Player)minecraft.player, e);
                minecraft.setScreen(null);
            }
        } else {
            List<Chapter> chapters = NarrativeCraftMod.getInstance().getChapterManager().getChapters();
            Subscene oldSubscene = new Subscene(existing.getName(), existing.getDescription(), this.scene);
            try {
                existing.setName(name);
                existing.setDescription(description);
                NarrativeCraftFile.updateSubsceneFile(this.scene);
                for (Chapter chapter : chapters) {
                    for (Scene scene : chapter.getSortedSceneList()) {
                        NarrativeCraftFile.updateCutsceneFile(scene);
                    }
                }
                minecraft.setScreen((Screen)new SubscenesScreen(this.scene));
            }
            catch (Exception e) {
                existing.setName(oldSubscene.getName());
                existing.setDescription(oldSubscene.getDescription());
                Util.sendCrashMessage((Player)minecraft.player, e);
                minecraft.setScreen(null);
            }
        }
    }
}

