/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.mainScreen.MainScreen;
import fr.loudo.narrativecraft.screens.options.StoryOptionsScreen;
import fr.loudo.narrativecraft.screens.storyManager.chapter.ChaptersScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class OpenScreenCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nc").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"open").then(class_2170.method_9247((String)"story_manager").executes(OpenScreenCommand::openStoryManager))).then(class_2170.method_9247((String)"character_manager").executes(OpenScreenCommand::openCharacterManager))).then(class_2170.method_9247((String)"story_options").executes(OpenScreenCommand::openStoryOptions))).then(class_2170.method_9247((String)"main_screen").executes(OpenScreenCommand::openMainScreen))));
    }

    private static int openStoryOptions(CommandContext<class_2168> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession.getStoryHandler() != null) {
            return 0;
        }
        if (playerSession.getController() != null) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        StoryOptionsScreen screen = new StoryOptionsScreen(playerSession);
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)screen));
        return 1;
    }

    private static int openStoryManager(CommandContext<class_2168> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession.getController() != null) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        if (playerSession.getStoryHandler() != null) {
            return 0;
        }
        ChaptersScreen chaptersScreen = new ChaptersScreen();
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)chaptersScreen));
        return 1;
    }

    private static int openCharacterManager(CommandContext<class_2168> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession.getController() != null) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        CharactersScreen screen = new CharactersScreen(null);
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)screen));
        return 1;
    }

    private static int openMainScreen(CommandContext<class_2168> context) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession.getStoryHandler() != null) {
            return 0;
        }
        if (playerSession.getController() != null) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("session.controller_set", new Object[0]));
            return 0;
        }
        if (NarrativeCraftMod.getInstance().getRecordingManager().isRecording(playerSession.getPlayer())) {
            playerSession.getPlayer().method_64398((class_2561)Translation.message("record.cant_access", new Object[0]));
            return 0;
        }
        MainScreen screen = new MainScreen(playerSession, false, false);
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)screen));
        return 1;
    }
}

