/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog.animation;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.gui.ICustomGuiRender;
import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer;
import fr.loudo.narrativecraft.util.Easing;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;

public class DialogArrowSkip {
    private final double translateTime = 0.4;
    private final DialogRenderer dialogRenderer;
    private float width;
    private float height;
    private float offset;
    private float xTranslatePoint;
    private int color;
    private int currentTick;
    private int totalTick;
    private boolean isRunning = false;

    public DialogArrowSkip(DialogRenderer dialogRenderer, float width, float height, float xTranslatePoint, float offset, int color) {
        this.dialogRenderer = dialogRenderer;
        this.width = width;
        this.height = height;
        this.xTranslatePoint = xTranslatePoint;
        this.offset = offset;
        this.color = class_9848.method_61330((int)204, (int)color);
        this.totalTick = 8;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.currentTick = 0;
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void tick() {
        if (this.currentTick < this.totalTick && this.isRunning) {
            ++this.currentTick;
        }
    }

    public void render(class_4587 poseStack, class_4597.class_4598 bufferSource, float partialTick) {
        if (!this.isRunning) {
            return;
        }
        double translateX = -this.dialogRenderer.getPaddingX() * 2.0f + this.offset;
        int originalColor = this.color;
        if (this.currentTick < this.totalTick) {
            double t = Math.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), 0.0, 1.0);
            t = Easing.SMOOTH.interpolate(t);
            translateX = class_3532.method_16436((double)t, (double)(translateX + (double)this.xTranslatePoint), (double)translateX);
            double opacity = class_3532.method_16436((double)t, (double)0.0, (double)0.8);
            originalColor = class_9848.method_61330((int)((int)(opacity * 255.0)), (int)this.color);
        }
        poseStack.method_22904(translateX, 0.0, 0.0);
        this.draw(poseStack, bufferSource, originalColor);
    }

    private void draw(class_4587 poseStack, class_4597.class_4598 bufferSource, int color) {
        class_4588 vertexConsumer = bufferSource.method_73477(NarrativeCraftMod.dialogBackgroundRenderType);
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float xStart = this.dialogRenderer.getTotalWidth() - this.width - this.offset;
        float xEnd = this.dialogRenderer.getTotalWidth() + this.width - this.offset;
        vertexConsumer.method_22918(matrix4f, xStart, -this.height, 0.01f).method_39415(color).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, xStart, this.height, 0.01f).method_39415(color).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, xEnd, 0.0f, 0.01f).method_39415(color).method_60803(0xF000F0);
        vertexConsumer.method_22918(matrix4f, xStart, -this.height, 0.01f).method_39415(color).method_60803(0xF000F0);
    }

    public void render(class_332 guiGraphics, float partialTick) {
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        double translateX = 0.0;
        double opacity = this.isRunning ? 1.0 : 0.0;
        poseStack.pushMatrix();
        if (this.currentTick < this.totalTick) {
            double t = Math.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), 0.0, 1.0);
            t = Easing.SMOOTH.interpolate(t);
            translateX = class_3532.method_16436((double)t, (double)this.xTranslatePoint, (double)translateX);
            opacity = class_3532.method_16436((double)t, (double)0.0, (double)1.0);
        }
        poseStack.translate((float)translateX + this.offset, 0.0f);
        ((ICustomGuiRender)guiGraphics).narrativecraft$drawDialogSkip(this.width, this.height, class_9848.method_61330((int)((int)(opacity * 255.0)), (int)this.color));
        poseStack.popMatrix();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getOffset() {
        return this.offset;
    }

    public int getColor() {
        return this.color;
    }
}

