/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import com.zigythebird.playeranimcore.animation.Animation;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.platform.Services;
import fr.loudo.narrativecraft.util.Translation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.common.tools.UUIDMap;
import io.github.kosmx.emotes.mc.McUtils;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class EmoteInkAction
extends InkAction {
    private String action;
    private boolean forced;
    private Animation emote;
    private CharacterStory characterStory;

    public EmoteInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (!Services.PLATFORM.isModLoaded("emotecraft")) {
            return InkActionResult.ignored();
        }
        if (arguments.size() < 2) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Action, play or stop"));
        }
        this.action = arguments.get(1);
        if (arguments.size() < 3) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Emote name"));
        }
        if (!this.action.equals("play") && !this.action.equals("stop")) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", "Only play or stop"));
        }
        String emoteName = arguments.get(2);
        this.emote = this.getEmote(emoteName, (UUIDMap<Animation>)UniversalEmoteSerializer.getLoadedEmotes());
        if (this.emote == null) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.wrong_argument", String.format("Emote %s does not exists.", emoteName)));
        }
        if (arguments.size() < 4) {
            return InkActionResult.error((class_2561)Translation.message("ink_action.validation.miss_argument", "Character name"));
        }
        String characterName = arguments.get(3);
        this.characterStory = NarrativeCraftMod.getInstance().getCharacterManager().getCharacterByName(characterName);
        if (this.characterStory == null) {
            this.characterStory = scene.getNpcByName(characterName);
        }
        if (this.characterStory == null) {
            return InkActionResult.error((class_2561)Translation.message("character.no_exists", characterName));
        }
        if (arguments.size() > 4) {
            try {
                this.forced = Boolean.parseBoolean(arguments.get(4));
            }
            catch (Exception e) {
                return InkActionResult.error((class_2561)Translation.message("ink_action.validation.boolean", arguments.get(4)));
            }
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        this.isRunning = false;
        if (!Services.PLATFORM.isModLoaded("emotecraft")) {
            return InkActionResult.ignored();
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return InkActionResult.ignored();
        }
        CharacterRuntime characterRuntime = storyHandler.getCharacterRuntimeFromCharacter(this.characterStory);
        if (characterRuntime == null || characterRuntime.getEntity() == null) {
            return InkActionResult.ignored();
        }
        ServerEmoteAPI.playEmote((UUID)characterRuntime.getEntity().method_5667(), (Animation)this.emote, (boolean)this.forced);
        return InkActionResult.ok();
    }

    private Animation getEmote(String id, UUIDMap<Animation> emotes) {
        try {
            UUID emoteID = UUID.fromString(id);
            for (Animation keyframeAnimation : emotes) {
                if (!keyframeAnimation.get().equals(emoteID)) continue;
                return keyframeAnimation;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (Animation animation : emotes) {
            String name = class_3544.method_57180((String)McUtils.fromJson((Object)animation.data().getRaw("name"), (class_7225.class_7874)class_5455.field_40585).getString());
            if (!name.equalsIgnoreCase(id)) continue;
            return animation;
        }
        return null;
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

