/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.dialog.DialogData;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.util.InkUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;

public class OnEnterInkAction
extends InkAction {
    public OnEnterInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        this.isRunning = false;
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            return InkActionResult.ignored();
        }
        String currentKnot = storyHandler.getStory().getState().getCurrentKnot();
        if (currentKnot == null || currentKnot.equalsIgnoreCase(playerSession.getScene().knotName())) {
            return InkActionResult.ignored();
        }
        if (!currentKnot.matches(InkUtil.SCENE_KNOT_PATTERN.pattern())) {
            return InkActionResult.ignored();
        }
        String[] splitKnot = currentKnot.split("_");
        if (splitKnot.length < 2) {
            return InkActionResult.ignored();
        }
        int chapterIndex = Integer.parseInt(splitKnot[1]);
        Chapter chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(chapterIndex);
        if (chapter == null) {
            return InkActionResult.error("Chapter " + chapterIndex + " does not exists!");
        }
        String sceneName = splitKnot.length > 2 ? String.join((CharSequence)" ", Arrays.copyOfRange(splitKnot, 2, splitKnot.length)) : chapter.getSortedSceneList().getFirst().getName();
        Scene scene = chapter.getSceneByName(sceneName);
        if (scene == null) {
            return InkActionResult.error("Scene " + sceneName + " of chapter " + chapterIndex + " does not exists!");
        }
        playerSession.setChapter(chapter);
        playerSession.setScene(scene);
        for (InkAction inkAction : playerSession.getInkActions()) {
            inkAction.stop();
        }
        playerSession.getInkActions().clear();
        for (Playback playback : playerSession.getPlaybackManager().getPlaybacks()) {
            playback.stop(true);
        }
        for (CharacterRuntime characterRuntime : playerSession.getCharacterRuntimes()) {
            if (characterRuntime.getEntity() == null) continue;
            characterRuntime.getEntity().method_5650(class_1297.class_5529.field_26998);
        }
        playerSession.getCharacterRuntimes().clear();
        storyHandler.setDialogData(DialogData.globalDialogData);
        storyHandler.save(true);
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

