/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.playback;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.mixin.invoker.LivingEntityInvoker;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.ActionsData;
import fr.loudo.narrativecraft.narrative.recording.actions.BreakBlockAction;
import fr.loudo.narrativecraft.util.FakePlayer;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_3730;
import net.minecraft.class_7923;

public class PlaybackData {
    private final ActionsData actionsData;
    private final Playback playback;
    private class_1297 entity;
    private int localTick;

    public PlaybackData(ActionsData actionsData, Playback playback) {
        this.actionsData = actionsData;
        this.localTick = 0;
        this.playback = playback;
    }

    public void tick(int globalTick) {
        if (globalTick >= this.actionsData.getSpawnTick() && this.entity == null) {
            this.spawnEntity(this.actionsData.getLocations().getFirst());
        }
        if (this.entity == null) {
            return;
        }
        List<Location> movements = this.actionsData.getLocations();
        if (this.localTick >= movements.size()) {
            return;
        }
        Location current = movements.get(this.localTick);
        Location next = this.localTick + 1 < movements.size() ? movements.get(this.localTick + 1) : current;
        this.moveEntity(current, next, false);
        ++this.localTick;
    }

    public class_1937 getLevel() {
        return this.entity.method_37908();
    }

    public void changeLocationByTick(int newTick, boolean seamless) {
        if (newTick >= this.actionsData.getSpawnTick()) {
            if (this.entity == null) {
                this.spawnEntity(this.actionsData.getLocations().getFirst());
            }
        } else {
            this.killEntity();
            this.reset();
            return;
        }
        this.localTick = newTick - this.actionsData.getSpawnTick();
        Location location = this.actionsData.getLocations().get(this.localTick);
        if (seamless) {
            this.moveEntity(location, location, true);
        } else {
            this.killEntity();
            this.spawnEntity(location);
        }
    }

    public void killEntity() {
        if (this.entity == null) {
            return;
        }
        this.entity.method_5650(class_1297.class_5529.field_26998);
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof FakePlayer) {
            FakePlayer fakePlayer = (FakePlayer)class_12972;
            Util.removeFakePlayerUUID(fakePlayer);
        }
        this.entity = null;
    }

    public void spawnEntity(Location location) {
        if (this.actionsData.getEntityId() == class_7923.field_41177.method_10206((Object)class_1299.field_6097)) {
            return;
        }
        class_1299 entityType = (class_1299)class_7923.field_41177.method_10200(this.actionsData.getEntityId());
        this.entity = entityType.method_5883(this.playback.getLevel(), class_3730.field_16471);
        if (this.entity == null) {
            return;
        }
        try {
            this.entity.method_5651(Util.valueInputFromCompoundTag(this.entity.method_56673(), this.actionsData.getNbtData()));
        }
        catch (CommandSyntaxException e) {
            NarrativeCraftMod.LOGGER.error("Unexpected error when trying to load nbt entity data! ", (Throwable)e);
            return;
        }
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1308) {
            class_1308 mob = (class_1308)class_12972;
            mob.method_5977(true);
        }
        this.moveEntity(location, location, true);
        class_12972 = this.entity;
        if (class_12972 instanceof class_1542) {
            class_1542 itemEntity = (class_1542)class_12972;
            List<Action> actions = this.playback.getMasterEntityData().getActions().stream().filter(action -> action instanceof BreakBlockAction && action.getTick() == this.playback.getTick() - 1).toList();
            boolean randomizeMotion = !actions.isEmpty();
            this.entity = ((LivingEntityInvoker)this.playback.getMasterEntity()).callCreateItemStackToDrop(itemEntity.method_6983(), randomizeMotion, false);
        }
        this.playback.getLevel().method_8649(this.entity);
    }

    private void moveEntity(Location current, Location next, boolean silent) {
        if (this.entity == null) {
            return;
        }
        this.entity.method_36457(current.pitch());
        this.entity.method_36456(current.yaw());
        this.entity.method_5847(current.yaw());
        this.entity.method_24830(current.onGround());
        this.entity.method_5859(current.x(), current.y(), current.z());
        if (!silent) {
            this.entity.method_5784(class_1313.field_6308, Location.deltaLocation(current, next).asVec3());
        }
    }

    public void reset() {
        this.localTick = 0;
        this.actionsData.reset(this.entity);
    }

    public boolean hasEnded() {
        return this.localTick >= this.actionsData.getLocations().size();
    }

    public ActionsData getActionsData() {
        return this.actionsData;
    }

    public int getLocalTick() {
        return this.localTick;
    }

    public void setLocalTick(int localTick) {
        this.localTick = localTick;
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public void setEntity(class_1297 entity) {
        this.entity = entity;
    }

    public Playback getPlayback() {
        return this.playback;
    }
}

