/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.keyframe;

import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public abstract class AbstractKeyframesBase<T extends Keyframe>
extends AbstractKeyframeController<T> {
    protected final List<T> keyframes = new ArrayList<T>();

    public AbstractKeyframesBase(Environment environment, class_1657 player) {
        super(environment, player);
    }

    @Override
    public T getNextKeyframe(T toKeyframe) {
        for (int i = 0; i < this.keyframes.size() - 1; ++i) {
            if (((Keyframe)this.keyframes.get(i)).getId() != ((Keyframe)toKeyframe).getId()) continue;
            return (T)((Keyframe)this.keyframes.get(i + 1));
        }
        return toKeyframe;
    }

    @Override
    public T getPreviousKeyframe(T fromKeyframe) {
        for (int i = 0; i < this.keyframes.size(); ++i) {
            if (((Keyframe)this.keyframes.get(i)).getId() != ((Keyframe)fromKeyframe).getId()) continue;
            if (i == 0) {
                return fromKeyframe;
            }
            return (T)((Keyframe)this.keyframes.get(i - 1));
        }
        return fromKeyframe;
    }

    @Override
    public T getKeyframeByEntity(class_1297 entity) {
        for (Keyframe keyframe : this.keyframes) {
            if (!Util.isSameEntity(entity, (class_1297)keyframe.getCamera())) continue;
            return (T)keyframe;
        }
        return null;
    }

    @Override
    public void hideKeyframes(class_3222 player) {
        for (Keyframe keyframe : this.keyframes) {
            keyframe.hideKeyframe(player);
        }
    }

    @Override
    public void showKeyframes(class_3222 player) {
        for (Keyframe keyframe : this.keyframes) {
            keyframe.showKeyframe(player);
        }
    }

    @Override
    public void removeKeyframe(T keyframe) {
        this.keyframes.remove(keyframe);
        ((Keyframe)keyframe).hideKeyframe(this.playerSession.getPlayer());
    }

    public List<T> getKeyframes() {
        return this.keyframes;
    }
}

