/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.KeyframeOptionScreen;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneKeyframeAdvancedSettings;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7842;

public class CutsceneKeyframeOptionScreen
extends KeyframeOptionScreen<CutsceneKeyframe, CutsceneController> {
    private final CutsceneController cutsceneController;
    private final CutsceneKeyframeGroup cutsceneKeyframeGroup;
    private class_342 startDelayBox;
    private class_342 pathTimeBox;
    private class_342 transitionDelayBox;
    private class_342 speedBox;

    public CutsceneKeyframeOptionScreen(CutsceneKeyframe keyframe, PlayerSession playerSession, boolean hide) {
        super(keyframe, (CutsceneController)playerSession.getController(), playerSession, hide);
        this.cutsceneController = (CutsceneController)playerSession.getController();
        this.cutsceneKeyframeGroup = (CutsceneKeyframeGroup)this.cutsceneController.getKeyframeGroupOfKeyframe(keyframe);
        this.reloadScreen = () -> this.field_22787.method_1507((class_437)new CutsceneKeyframeOptionScreen(keyframe, playerSession, false));
    }

    @Override
    protected void method_25426() {
        if (!this.hide) {
            if (!((CutsceneKeyframe)this.keyframe).isParentGroup()) {
                this.pathTimeBox = this.addLabeledEditBox((class_2561)Translation.message("screen.keyframe_option.path_time", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getPathTick())));
                this.speedBox = this.addLabeledEditBox((class_2561)Translation.message("screen.keyframe_option.speed", new Object[0]), String.valueOf(((CutsceneKeyframe)this.keyframe).getSpeed()));
            }
            if (this.cutsceneKeyframeGroup.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
                this.transitionDelayBox = this.addLabeledEditBox((class_2561)Translation.message("screen.keyframe_option.transition_delay", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getTransitionDelayTick())));
            } else {
                this.startDelayBox = this.addLabeledEditBox((class_2561)Translation.message("screen.keyframe_option.start_delay", new Object[0]), String.valueOf(MathHelper.tickToSeconds(((CutsceneKeyframe)this.keyframe).getStartDelayTick())));
            }
            this.initPositionLabelBox();
            this.initSliders();
            this.initButtons();
            this.initTextSelectedKeyframe();
        }
        this.initLittleButtons();
        this.currentY = 15;
    }

    public void method_25419() {
    }

    @Override
    protected void initButtons() {
        int gap = 15;
        int margin = 15;
        class_5250 updateTitle = Translation.message("screen.keyframe_option.update", new Object[0]);
        class_4185 updateButton = class_4185.method_46430((class_2561)updateTitle, button -> {
            this.updateValues();
            this.cutsceneController.updateCurrentTick(((CutsceneKeyframe)this.keyframe).getTick());
            this.cutsceneController.changeTimePosition(((CutsceneKeyframe)this.keyframe).getTick(), true);
        }).method_46434(20, this.currentY, this.field_22793.method_27525((class_5348)updateTitle) + margin, 20).method_46431();
        class_5250 playTitle = Translation.message("screen.keyframe_option.play_from_here", new Object[0]);
        class_4185 playFromHere = class_4185.method_46430((class_2561)playTitle, button -> {
            if (this.playerSession != null) {
                CutscenePlayback cutscenePlayback = this.cutsceneController.getCutscenePlayback();
                if (this.cutsceneKeyframeGroup.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
                    if (this.cutsceneKeyframeGroup.getKeyframes().size() > 1) {
                        CutsceneKeyframe previous = this.cutsceneController.getPreviousKeyframe((CutsceneKeyframe)this.keyframe);
                        cutscenePlayback.setupAndPlay(previous, (CutsceneKeyframe)this.keyframe);
                        int offset = ((CutsceneKeyframe)this.keyframe).getTick() - previous.getTick();
                        cutscenePlayback.setSegmentTick(offset);
                        cutscenePlayback.setTotalTick(previous.getTick() + offset);
                    } else {
                        cutscenePlayback.setupAndPlay((CutsceneKeyframe)this.keyframe, (CutsceneKeyframe)this.keyframe);
                    }
                } else {
                    cutscenePlayback.setupAndPlay((CutsceneKeyframe)this.keyframe, this.cutsceneController.getNextKeyframe((CutsceneKeyframe)this.keyframe));
                }
                NarrativeCraftMod.server.execute(() -> this.cutsceneController.setPlaying(true));
                this.field_22787.method_1507(null);
            }
        }).method_46434(updateButton.method_25368() + updateButton.method_46426() + 5, this.currentY, this.field_22793.method_27525((class_5348)playTitle) + margin, 20).method_46431();
        this.currentY += 20 + gap - 10;
        class_5250 advancedTitle = Translation.message("screen.keyframe_option.advanced", new Object[0]);
        class_4185 advancedButton = class_4185.method_46430((class_2561)advancedTitle, button -> {
            CutsceneKeyframeAdvancedSettings screen = new CutsceneKeyframeAdvancedSettings((class_437)this, (CutsceneKeyframe)this.keyframe);
            this.field_22787.method_1507((class_437)screen);
        }).method_46434(20, this.currentY, this.field_22793.method_27525((class_5348)advancedTitle) + margin, 20).method_46431();
        this.currentY += 20 + gap;
        class_5250 removeTitle = Translation.message("global.remove", new Object[0]);
        class_4185 removeKeyframe = class_4185.method_46430((class_2561)removeTitle, button -> {
            class_410 confirmScreen = new class_410(b -> {
                if (b) {
                    if (this.playerSession != null) {
                        this.cutsceneController.setCamera(null);
                        this.cutsceneController.removeKeyframe((CutsceneKeyframe)this.keyframe);
                        this.cutsceneController.updateCurrentTick(((CutsceneKeyframe)this.keyframe).getTick());
                        this.field_22787.method_1507(null);
                    }
                } else {
                    CutsceneKeyframeOptionScreen screen = new CutsceneKeyframeOptionScreen((CutsceneKeyframe)this.keyframe, this.playerSession, false);
                    this.field_22787.method_1507((class_437)screen);
                }
            }, (class_2561)class_2561.method_43470((String)""), (class_2561)Translation.message("global.confirm_delete", new Object[0]), class_5244.field_24336, class_5244.field_24335);
            this.field_22787.method_1507((class_437)confirmScreen);
        }).method_46434(20, this.currentY, this.field_22793.method_27525((class_5348)removeTitle) + margin, 20).method_46431();
        this.method_37063((class_364)updateButton);
        this.method_37063((class_364)advancedButton);
        if (!this.cutsceneController.isLastKeyframe((CutsceneKeyframe)this.keyframe)) {
            this.method_37063((class_364)playFromHere);
        }
        this.method_37063((class_364)removeKeyframe);
    }

    @Override
    protected void initTextSelectedKeyframe() {
        int y = 10;
        class_5250 groupText = Translation.message("screen.keyframe_option.keyframe_group", this.cutsceneKeyframeGroup.getId());
        class_5250 keyframeText = Translation.message("screen.keyframe_option.keyframe_id", ((CutsceneKeyframe)this.keyframe).getId());
        int groupWidth = this.field_22793.method_27525((class_5348)groupText);
        int keyframeWidth = this.field_22793.method_27525((class_5348)keyframeText);
        int spacing = 5;
        int totalWidth = groupWidth + spacing + keyframeWidth;
        int startX = (this.field_22789 - totalWidth) / 2;
        class_7842 groupLabel = ScreenUtils.text((class_2561)groupText, this.field_22793, startX, y, 2608927);
        class_7842 keyframeIdLabel = ScreenUtils.text((class_2561)keyframeText, this.field_22793, startX + groupWidth + spacing, y, 15844367);
        this.method_37063((class_364)groupLabel);
        this.method_37063((class_364)keyframeIdLabel);
    }

    @Override
    protected void updateValues() {
        if (this.startDelayBox != null) {
            try {
                float startDelayVal = Float.parseFloat(this.startDelayBox.method_1882());
                ((CutsceneKeyframe)this.keyframe).setStartDelayTick(MathHelper.secondsToTick(startDelayVal));
            }
            catch (NumberFormatException startDelayVal) {
                // empty catch block
            }
        }
        if (this.transitionDelayBox != null) {
            try {
                float transitionDelayValue = Float.parseFloat(this.transitionDelayBox.method_1882());
                ((CutsceneKeyframe)this.keyframe).setTransitionDelayTick(MathHelper.secondsToTick(transitionDelayValue));
            }
            catch (NumberFormatException transitionDelayValue) {
                // empty catch block
            }
        }
        if (this.speedBox != null) {
            try {
                double speedValue = Double.parseDouble(this.speedBox.method_1882());
                ((CutsceneKeyframe)this.keyframe).setSpeed(speedValue);
            }
            catch (NumberFormatException speedValue) {
                // empty catch block
            }
        }
        try {
            float pathTimeVal = this.pathTimeBox == null ? 0.0f : Float.parseFloat(this.pathTimeBox.method_1882());
            ((CutsceneKeyframe)this.keyframe).setPathTick(MathHelper.secondsToTick(pathTimeVal));
        }
        catch (NumberFormatException pathTimeVal) {
            // empty catch block
        }
        KeyframeLocation location = this.getKeyframeLocation();
        ((CutsceneKeyframe)this.keyframe).setKeyframeLocation(location);
        ((CutsceneKeyframe)this.keyframe).updateEntityData(this.player);
    }

    private KeyframeLocation getKeyframeLocation() {
        KeyframeLocation location = ((CutsceneKeyframe)this.keyframe).getKeyframeLocation();
        location.setPitch(this.upDownValue);
        location.setYaw(this.leftRightValue);
        location.setRoll(this.rotationValue);
        try {
            float xVal = Float.parseFloat(((class_342)this.coordinatesBoxList.get(0)).method_1882());
            float yVal = Float.parseFloat(((class_342)this.coordinatesBoxList.get(1)).method_1882());
            float zVal = Float.parseFloat(((class_342)this.coordinatesBoxList.get(2)).method_1882());
            location.setX(xVal);
            location.setY(yVal);
            location.setZ(zVal);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        location.setFov(this.fovValue);
        return location;
    }
}

