/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.gui;

import fr.loudo.narrativecraft.util.ImageFontConstants;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class StorySaveIconGui {
    private final Minecraft minecraft = Minecraft.getInstance();
    private int currentTick;
    private int totalTickIn;
    private int totalTickStay;
    private int totalTickOut;
    private int totalTick;
    private State state = State.IN;
    private boolean saving;
    private boolean debugMode;

    public StorySaveIconGui(double in, double stay, double out) {
        this.totalTickIn = (int)(in * 20.0);
        this.totalTickStay = (int)(stay * 20.0);
        this.totalTickOut = (int)(out * 20.0);
        this.totalTick = this.totalTickIn;
    }

    public void tick() {
        if (!this.saving) {
            return;
        }
        if (this.currentTick < this.totalTick) {
            ++this.currentTick;
        }
        if (this.currentTick == this.totalTick) {
            this.currentTick = 0;
            switch (this.state.ordinal()) {
                case 0: {
                    this.totalTick = this.totalTickStay;
                    this.state = State.STAY;
                    break;
                }
                case 1: {
                    this.totalTick = this.totalTickOut;
                    this.state = State.OUT;
                    break;
                }
                case 2: {
                    this.saving = false;
                }
            }
        }
    }

    public void showSave(boolean debugMode) {
        this.debugMode = debugMode;
        this.currentTick = 0;
        this.saving = true;
        this.state = State.IN;
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        if (!this.saving) {
            return;
        }
        double t = Mth.clamp((double)(((float)this.currentTick + partialTick) / (float)this.totalTick), (double)0.0, (double)1.0);
        double opacity = 1.0;
        switch (this.state.ordinal()) {
            case 0: {
                opacity = Mth.lerp((double)t, (double)0.0, (double)1.0);
                break;
            }
            case 2: {
                opacity = Mth.lerp((double)t, (double)1.0, (double)0.0);
            }
        }
        String logo = ImageFontConstants.SAVE.getString();
        int logoWidth = this.minecraft.font.width(logo);
        int width = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        int x = width - logoWidth - 30;
        int y = height - 30;
        guiGraphics.drawString(this.minecraft.font, logo, x, y, FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)0xFFFFFF), false);
        if (this.debugMode) {
            MutableComponent message = Component.literal((String)"Fake save (debug)");
            Font font = this.minecraft.font;
            int n = x - this.minecraft.font.width((FormattedText)message) / 2 - 5;
            Objects.requireNonNull(this.minecraft.font);
            guiGraphics.drawString(font, (Component)message, n, y - 9 - 10, FastColor.ARGB32.color((int)((int)(opacity * 255.0)), (int)0xFFFFFF), false);
        }
    }

    static enum State {
        IN,
        STAY,
        OUT;

    }
}

