/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.hud;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;

public class StoryDebugHud {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final PlayerSession playerSession;

    public StoryDebugHud(PlayerSession playerSession) {
        this.playerSession = playerSession;
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        if (this.playerSession.getStoryHandler() == null) {
            return;
        }
        ArrayList<InkAction> inkActions = new ArrayList<InkAction>(this.playerSession.getInkActions());
        int x = 5;
        int y = 5;
        int color = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
        guiGraphics.drawString(this.minecraft.font, "Ink tag running:", x, y, color);
        Objects.requireNonNull(this.minecraft.font);
        y += 9 + 5;
        for (InkAction inkAction2 : inkActions) {
            Object command = inkAction2.getCommand();
            if (((String)command).length() > 25) {
                command = ((String)command).substring(0, 25) + "...";
            }
            guiGraphics.drawString(this.minecraft.font, "\"" + (String)command + "\"", x, y, color);
            Objects.requireNonNull(this.minecraft.font);
            y += 9 + 5;
        }
        y = 5;
        String headerTag = "Ink tag running:";
        String longestInkCommand = inkActions.stream().map(inkAction -> {
            Object command = inkAction.getCommand();
            if (((String)command).length() > 25) {
                command = ((String)command).substring(0, 25) + "...";
            }
            return "\"" + (String)command + "\"";
        }).max(Comparator.comparingInt(String::length)).orElse(headerTag);
        guiGraphics.drawString(this.minecraft.font, "Characters in the world:", x += this.minecraft.font.width(headerTag.length() > longestInkCommand.length() ? headerTag : longestInkCommand) + 10, y, color);
        Objects.requireNonNull(this.minecraft.font);
        y += 9 + 5;
        List<CharacterRuntime> characterRuntimes = this.playerSession.getCharacterRuntimes();
        for (CharacterRuntime characterRuntime2 : characterRuntimes) {
            guiGraphics.drawString(this.minecraft.font, characterRuntime2.getCharacterStory().getName(), x, y, color);
            Objects.requireNonNull(this.minecraft.font);
            y += 9 + 5;
        }
        String headerChara = "Characters in the world:";
        String longestCharaName = characterRuntimes.stream().map(characterRuntime -> characterRuntime.getCharacterStory().getName()).max(Comparator.comparingInt(String::length)).orElse(headerChara);
        guiGraphics.drawString(this.minecraft.font, "Session:", x += this.minecraft.font.width(headerChara.length() > longestCharaName.length() ? headerChara : longestCharaName) + 10, 5, color);
        String chapterText = "Chapter " + this.playerSession.getChapter().getIndex();
        Font font = this.minecraft.font;
        Objects.requireNonNull(this.minecraft.font);
        guiGraphics.drawString(font, chapterText, x, 9 + 10, color);
        String sceneName = this.playerSession.getScene().getName();
        Font font2 = this.minecraft.font;
        Objects.requireNonNull(this.minecraft.font);
        guiGraphics.drawString(font2, sceneName, x, 9 + 23, color);
        String stitchName = this.playerSession.getStitch();
        if (stitchName != null) {
            Font font3 = this.minecraft.font;
            Objects.requireNonNull(this.minecraft.font);
            guiGraphics.drawString(font3, stitchName, x, 9 + 35, color);
        }
    }
}

