/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.dialog;

import fr.loudo.narrativecraft.narrative.dialog.DialogRenderer3D;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class DialogEntityBobbing {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final int entityId;
    private final float shakeDecayRate;
    private float noiseShakeSpeed;
    private float noiseShakeStrength;
    private final SimplexNoise noise;
    private float noiseI = 0.0f;
    private float lastOffsetX = 0.0f;
    private float lastOffsetY = 0.0f;
    private float currentOffsetX = 0.0f;
    private float currentOffsetY = 0.0f;
    private float lastXRot;
    private float lastYRot;

    public DialogEntityBobbing(DialogRenderer3D dialogRenderer3D, float noiseShakeSpeed, float noiseShakeStrength) {
        LivingEntity entity = dialogRenderer3D.getCharacterRuntime().getEntity();
        if (entity != null) {
            this.lastXRot = entity.getXRot();
            this.lastYRot = entity.getYRot();
        }
        this.entityId = dialogRenderer3D.getCharacterRuntime().getEntity().getId();
        this.noise = new SimplexNoise(RandomSource.create());
        this.noiseShakeSpeed = noiseShakeSpeed;
        this.shakeDecayRate = 0.0f;
        this.noiseShakeStrength = noiseShakeStrength;
    }

    public void tick() {
        this.noiseI += 0.05f * this.noiseShakeSpeed;
        float noiseShakeStrength = Mth.lerp((float)(this.shakeDecayRate * 0.05f), (float)this.noiseShakeStrength, (float)0.0f);
        this.lastOffsetX = this.currentOffsetX;
        this.lastOffsetY = this.currentOffsetY;
        this.currentOffsetX = (float)this.noise.getValue(1.0, (double)this.noiseI) * noiseShakeStrength;
        this.currentOffsetY = (float)this.noise.getValue(100.0, (double)this.noiseI) * noiseShakeStrength;
        if (Math.abs(noiseShakeStrength) <= 0.0f) {
            this.lastOffsetY = 0.0f;
            this.lastOffsetX = 0.0f;
            this.currentOffsetY = 0.0f;
            this.currentOffsetX = 0.0f;
        }
    }

    public void partialTick(float partialTick) {
        Entity entity = this.minecraft.level.getEntity(this.entityId);
        if (entity == null) {
            return;
        }
        float interpolatedX = Mth.lerp((float)partialTick, (float)this.lastOffsetX, (float)this.currentOffsetX);
        float interpolatedY = Mth.lerp((float)partialTick, (float)this.lastOffsetY, (float)this.currentOffsetY);
        entity.setYRot(this.lastYRot + interpolatedY);
        entity.setYHeadRot(this.lastYRot + interpolatedY);
        entity.setXRot(this.lastXRot + interpolatedX);
    }

    public float getNoiseShakeSpeed() {
        return this.noiseShakeSpeed;
    }

    public void setNoiseShakeSpeed(float noiseShakeSpeed) {
        this.noiseShakeSpeed = noiseShakeSpeed;
    }

    public float getNoiseShakeStrength() {
        return this.noiseShakeStrength;
    }

    public void setNoiseShakeStrength(float noiseShakeStrength) {
        this.noiseShakeStrength = noiseShakeStrength;
    }
}

