/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SleepAction
extends Action {
    private int xB;
    private int yB;
    private int zB;

    public SleepAction(int tick, BlockPos bedPos) {
        super(tick, ActionType.SLEEP);
        this.xB = bedPos.getX();
        this.yB = bedPos.getY();
        this.zB = bedPos.getZ();
    }

    @Override
    public void execute(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setSleepingPos(new BlockPos(this.xB, this.yB, this.zB));
        }
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        Entity entity = playbackData.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.clearSleepingPos();
        }
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.xB, this.yB, this.zB);
    }
}

