/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.story.inkAction;

import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.api.inkAction.InkActionResult;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.Translation;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public class WeatherInkAction
extends InkAction {
    private String weather;
    private boolean instantly;

    public WeatherInkAction(String id, InkAction.Side side, String syntax, InkAction.CommandMatcher matcher) {
        super(id, side, syntax, matcher);
    }

    @Override
    protected InkActionResult doValidate(List<String> arguments, Scene scene) {
        if (arguments.size() == 1) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.miss_argument", "clear, rain or thunder"));
        }
        this.weather = arguments.get(1);
        if (!(this.weather.equals("clear") || this.weather.equals("rain") || this.weather.equals("thunder"))) {
            return InkActionResult.error((Component)Translation.message("ink_action.validation.wrong_argument", "Only clear, rain or thunder"));
        }
        if (arguments.size() > 2) {
            try {
                this.instantly = Boolean.parseBoolean(arguments.get(2));
            }
            catch (Exception e) {
                return InkActionResult.error((Component)Translation.message("ink_action.validation.boolean", arguments.get(2)));
            }
        }
        return InkActionResult.ok();
    }

    @Override
    protected InkActionResult doExecute(PlayerSession playerSession) {
        ServerLevel level = (ServerLevel)playerSession.getPlayer().level();
        ServerGamePacketListenerImpl connection = playerSession.getPlayer().connection;
        boolean isSinglePlayer = level.getServer().isSingleplayer();
        String string = this.weather;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"clear", "rain", "thunder"}, (Object)string, n)) {
            case 0: {
                if (this.instantly || !isSinglePlayer) {
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.STOP_RAINING, 0.0f));
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, 0.0f));
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f));
                    break;
                }
                level.setWeatherParameters(999999, 0, false, false);
                break;
            }
            case 1: {
                if (this.instantly || !isSinglePlayer) {
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, 1.0f));
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 0.0f));
                    break;
                }
                level.setWeatherParameters(0, 999999, true, false);
                break;
            }
            case 2: {
                if (this.instantly || !isSinglePlayer) {
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.START_RAINING, 0.0f));
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.RAIN_LEVEL_CHANGE, 1.0f));
                    connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.THUNDER_LEVEL_CHANGE, 1.0f));
                    break;
                }
                level.setWeatherParameters(0, 999999, true, true);
                break;
            }
            default: {
                return InkActionResult.error("Weather value is not correct.");
            }
        }
        playerSession.getInkActions().removeIf(inkAction -> inkAction instanceof WeatherInkAction);
        return InkActionResult.ok();
    }

    @Override
    public boolean needScene() {
        return false;
    }
}

