/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.characters;

import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class CharacterChangePoseScreen
extends Screen {
    private final Screen lastScreen;
    private final LivingEntity livingEntity;
    private final CharacterStoryData characterStoryData;

    public CharacterChangePoseScreen(Screen lastScreen, CharacterStoryData characterStoryData) {
        super((Component)Component.literal((String)"Change pose camera angle screen"));
        this.livingEntity = characterStoryData.getCharacterRuntime().getEntity();
        this.characterStoryData = characterStoryData;
        this.lastScreen = lastScreen;
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    protected void init() {
        List<Pose> poseList = List.of(Pose.STANDING, Pose.CROUCHING, Pose.SLEEPING, Pose.FALL_FLYING, Pose.SHOOTING);
        int gap = 3;
        int startY = this.height / 2 - gap - 5 * poseList.size() - 20;
        int startX = this.width - 80 - 10;
        for (Pose pose : poseList) {
            Button poseButton = Button.builder((Component)Component.literal((String)pose.name()), button -> {
                this.livingEntity.setPose(pose);
                this.characterStoryData.setPose(pose);
                SynchedEntityData entityData = this.livingEntity.getEntityData();
                byte currentMask = (Byte)entityData.get(EntityAccessor.getDATA_SHARED_FLAGS_ID());
                byte currentLivingEntityByte = (Byte)entityData.get(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS());
                if (pose == Pose.CROUCHING) {
                    entityData.set(EntityAccessor.getDATA_SHARED_FLAGS_ID(), (Object)((byte)(currentMask | 2)));
                    this.characterStoryData.setEntityByte((byte)(currentMask | 2));
                } else {
                    entityData.set(EntityAccessor.getDATA_SHARED_FLAGS_ID(), (Object)((byte)(currentMask & 0xFFFFFFFD)));
                    this.characterStoryData.setEntityByte((byte)(currentMask & 0xFFFFFFFD));
                }
                if (pose == Pose.SHOOTING) {
                    byte byteToAdd = 0;
                    if (!this.livingEntity.getItemBySlot(EquipmentSlot.OFFHAND).isEmpty()) {
                        byteToAdd = 1;
                    } else if (!this.livingEntity.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                        byteToAdd = 3;
                    }
                    if (currentLivingEntityByte == 0) {
                        entityData.set(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS(), (Object)byteToAdd);
                        this.characterStoryData.setLivingEntityByte(byteToAdd);
                    } else {
                        entityData.set(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS(), (Object)0);
                        this.characterStoryData.setLivingEntityByte((byte)0);
                    }
                }
            }).width(80).pos(startX, startY).build();
            startY += poseButton.getHeight() + gap;
            this.addRenderableWidget((GuiEventListener)poseButton);
        }
        Button closeBtn = Button.builder((Component)Translation.message("global.close", new Object[0]), button -> this.onClose()).width(80).pos(startX, startY).build();
        this.addRenderableWidget((GuiEventListener)closeBtn);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderBlurredBackground(float partialTick) {
    }
}

