/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.character;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.CharacterManager;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.CameraAngle;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.screens.characters.CharacterEntityTypeScreen;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.EditScreenCharacterAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CharactersScreen
extends StoryElementScreen {
    private final Scene scene;

    public CharactersScreen(Scene scene) {
        super((Component)(scene == null ? Translation.message("screen.story_manager.characters", new Object[0]) : Translation.message("screen.story_manager.npcs", scene.getName())));
        this.scene = scene;
    }

    public void onClose() {
        if (this.scene != null) {
            this.minecraft.setScreen((Screen)new ScenesMenuScreen(this.scene));
        } else {
            super.onClose();
        }
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<CharacterStory> screen = new EditInfoScreen<CharacterStory>(this, null, new EditScreenCharacterAdapter(this.scene));
            this.minecraft.setScreen(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addContents() {
        CharacterManager characterManager = NarrativeCraftMod.getInstance().getCharacterManager();
        List<CharacterStory> characterStories = this.scene == null ? characterManager.getCharacterStories() : this.scene.getNpcs();
        List<StoryElementList.StoryEntryData> entries = characterStories.stream().map(character -> {
            Button button = Button.builder((Component)Component.literal((String)character.getName()), button1 -> {}).build();
            button.active = false;
            Button entityTypeButton = Button.builder((Component)ImageFontConstants.ENTITY, button1 -> {
                CharacterEntityTypeScreen screen = new CharacterEntityTypeScreen(this, (CharacterStory)character);
                this.minecraft.setScreen((Screen)screen);
            }).build();
            entityTypeButton.setTooltip(Tooltip.create((Component)Translation.message("tooltip.character_entity_type", new Object[0])));
            return new StoryElementList.StoryEntryData(button, List.of(entityTypeButton), () -> this.minecraft.setScreen(new EditInfoScreen<CharacterStory>(this, (CharacterStory)character, new EditScreenCharacterAdapter(this.scene))), () -> {
                if (this.scene == null) {
                    characterManager.removeCharacter((CharacterStory)character);
                    NarrativeCraftFile.deleteCharacterFolder(character);
                } else {
                    this.scene.removeNpc((CharacterStory)character);
                    NarrativeCraftFile.deleteCharacterFolder(character, this.scene);
                }
                try {
                    for (Chapter chapter : NarrativeCraftMod.getInstance().getChapterManager().getChapters()) {
                        for (Scene scene1 : chapter.getSortedSceneList()) {
                            for (Animation animation : scene1.getAnimations()) {
                                if (!animation.getCharacter().getName().equalsIgnoreCase(character.getName())) continue;
                                animation.setCharacter(null);
                                NarrativeCraftFile.updateAnimationFile(animation);
                            }
                            for (CameraAngle cameraAngle : scene1.getCameraAngles()) {
                                cameraAngle.getCharacterStoryDataList().removeIf(characterStoryData -> characterStoryData.getCharacterStory().getName().equalsIgnoreCase(character.getName()));
                            }
                            NarrativeCraftFile.updateCameraAngles(scene1);
                        }
                    }
                }
                catch (Exception e) {
                    Util.sendCrashMessage((Player)this.minecraft.player, e);
                    this.minecraft.setScreen(null);
                    return;
                }
                this.minecraft.setScreen((Screen)new CharactersScreen(this.scene));
            });
        }).toList();
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    @Override
    protected void openFolder() {
        if (this.scene == null) {
            net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.characterDirectory.toPath());
        } else {
            net.minecraft.Util.getPlatform().openPath(NarrativeCraftFile.getNpcFolder(this.scene).toPath());
        }
    }
}

