/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.scene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.animations.AnimationsScreen;
import fr.loudo.narrativecraft.screens.storyManager.cameraAngle.CameraAngleScreen;
import fr.loudo.narrativecraft.screens.storyManager.character.CharactersScreen;
import fr.loudo.narrativecraft.screens.storyManager.cutscene.CutscenesScreen;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesScreen;
import fr.loudo.narrativecraft.screens.storyManager.subscene.SubscenesScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ScenesMenuScreen
extends StoryElementScreen {
    private final Scene scene;

    public ScenesMenuScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.scene_menu", scene.getName()));
        this.scene = scene;
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new ScenesScreen(this.scene.getChapter()));
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        int width = 200;
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)this.minecraft.player);
        if (playerSession.isSessionSet() && playerSession.getScene().equals(this.scene)) {
            width = 100;
            linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> {
                ScenesScreen screen = new ScenesScreen(this.scene.getChapter());
                this.minecraft.setScreen((Screen)screen);
            }).width(width).build());
            linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, p_345997_ -> this.minecraft.setScreen(null)).width(width).build());
        } else {
            linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_BACK, p_345997_ -> this.onClose()).width(width).build());
        }
    }

    @Override
    protected void addContents() {
        StoryElementList.StoryEntryData animation = new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("global.animation", new Object[0]), button -> this.minecraft.setScreen((Screen)new AnimationsScreen(this.scene))).build());
        StoryElementList.StoryEntryData cameraAngle = new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("global.camera_angle", new Object[0]), button -> this.minecraft.setScreen((Screen)new CameraAngleScreen(this.scene))).build());
        StoryElementList.StoryEntryData cutscene = new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("global.cutscene", new Object[0]), button -> this.minecraft.setScreen((Screen)new CutscenesScreen(this.scene))).build());
        Button interactionBtn = Button.builder((Component)Translation.message("global.interaction", new Object[0]), button -> {}).build();
        interactionBtn.active = false;
        interactionBtn.setTooltip(Tooltip.create((Component)Component.literal((String)"Coming soon!")));
        StoryElementList.StoryEntryData interaction = new StoryElementList.StoryEntryData(interactionBtn);
        StoryElementList.StoryEntryData npc = new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("global.npc", new Object[0]), button -> this.minecraft.setScreen((Screen)new CharactersScreen(this.scene))).build());
        StoryElementList.StoryEntryData subscene = new StoryElementList.StoryEntryData(Button.builder((Component)Translation.message("global.subscene", new Object[0]), button -> this.minecraft.setScreen((Screen)new SubscenesScreen(this.scene))).build());
        List<StoryElementList.StoryEntryData> entries = List.of(animation, cameraAngle, cutscene, interaction, npc, subscene);
        this.storyElementList = (StoryElementList)this.layout.addToContents((LayoutElement)new StoryElementList(this.minecraft, this, entries, true));
    }

    @Override
    protected void openFolder() {
        Util.getPlatform().openPath(NarrativeCraftFile.getSceneFolder(this.scene).toPath());
    }
}

