/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.util;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class ErrorLine {
    private final boolean isWarn;
    private final int line;
    private final Scene scene;
    private final Chapter chapter;
    private String fileName;
    private final String message;
    private final String lineText;

    public ErrorLine(int line, Chapter chapter, Scene scene, String message, String lineText, boolean isWarn) {
        this.line = line;
        this.chapter = chapter;
        this.scene = scene;
        if (scene != null) {
            this.fileName = scene.knotName() + ".ink";
        } else if (chapter != null) {
            this.fileName = chapter.knotName() + ".ink";
        }
        this.message = message;
        this.lineText = lineText;
        this.isWarn = isWarn;
    }

    public Component toMessage() {
        Chapter chapterToDisplay;
        if (this.scene == null && this.chapter == null) {
            return Component.empty().append((Component)Component.literal((String)this.lineText).withStyle(ChatFormatting.GRAY).withStyle(style -> style.withBold(Boolean.valueOf(false)))).append("\n").append((Component)Component.literal((String)("'" + this.message + "'")).withStyle(ChatFormatting.RED).withStyle(style -> style.withBold(Boolean.valueOf(false)))).append("\n");
        }
        MutableComponent result = Component.empty().append("\n");
        Chapter chapter = chapterToDisplay = this.scene != null ? this.scene.getChapter() : this.chapter;
        if (chapterToDisplay != null) {
            result = result.copy().append((Component)Component.literal((String)"Chapter: ").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)).append((Component)Component.literal((String)String.valueOf(chapterToDisplay.getIndex())).withStyle(ChatFormatting.RED).withStyle(style -> style.withBold(Boolean.valueOf(false)))).append("\n");
        }
        if (this.scene != null) {
            result = result.copy().append((Component)Component.literal((String)"Scene: ").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)).append((Component)Component.literal((String)(this.scene.getName() + " ")).withStyle(ChatFormatting.RED).withStyle(style -> style.withBold(Boolean.valueOf(false))));
        }
        if (this.fileName != null) {
            ClickEvent clickEvent = this.scene != null ? new ClickEvent(ClickEvent.Action.OPEN_FILE, NarrativeCraftFile.getScriptFile(this.scene).getAbsolutePath()) : new ClickEvent(ClickEvent.Action.OPEN_FILE, NarrativeCraftFile.getScriptFile(this.chapter).getAbsolutePath());
            result = result.copy().append((Component)Component.literal((String)("(" + this.fileName + ")")).withStyle(ChatFormatting.GRAY).withStyle(style -> style.withBold(Boolean.valueOf(false)).withClickEvent(clickEvent).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Translation.message("validation.quick_edit", new Object[0]))))).append("\n");
        }
        result = result.copy().append((Component)Translation.message("global.line", new Object[0]).withStyle(ChatFormatting.GOLD)).append(" " + this.line + ": ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)this.lineText).withStyle(ChatFormatting.GRAY).withStyle(style -> style.withBold(Boolean.valueOf(false)))).append("\n").append((Component)Component.literal((String)("'" + this.message + "'")).withStyle(this.isWarn ? ChatFormatting.YELLOW : ChatFormatting.RED).withStyle(style -> style.withBold(Boolean.valueOf(false)))).append("\n");
        return result;
    }

    public int getLine() {
        return this.line;
    }

    public Scene getScene() {
        return this.scene;
    }

    public Chapter getChapter() {
        return this.chapter;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLineText() {
        return this.lineText;
    }

    public boolean isWarn() {
        return this.isWarn;
    }
}

