/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.managers.RecordingManager;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.recording.Recording;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.screens.components.ChooseCharacterScreen;
import fr.loudo.narrativecraft.util.CommandUtil;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_437;

public class RecordCommand {
    private static final RecordingManager recordingManager = NarrativeCraftMod.getInstance().getRecordingManager();
    public static final List<class_3222> playerTryingOverride = new ArrayList<class_3222>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nc").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"record").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").then(class_2170.method_9247((String)"with").then(class_2170.method_9244((String)"subscenes", (ArgumentType)StringArgumentType.greedyString()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSubscenesOfScenesSuggestions()).executes(commandContext -> {
            String subscenes = StringArgumentType.getString((CommandContext)commandContext, (String)"subscenes");
            return RecordCommand.startRecordingWithSubscenes((CommandContext<class_2168>)commandContext, subscenes);
        })))).executes(RecordCommand::startRecording))).then(class_2170.method_9247((String)"stop").executes(RecordCommand::stopRecording))).then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)"animation_name", (ArgumentType)StringArgumentType.string()).executes(context -> RecordCommand.saveRecording((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"animation_name")))))));
    }

    private static int startRecording(CommandContext<class_2168> context) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (recordingManager.isRecording(player)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.start.already_recording", new Object[0]));
            return 0;
        }
        Recording recording = recordingManager.getRecording((class_1297)player);
        if (recording == null) {
            recording = new Recording((class_1309)((class_2168)context.getSource()).method_44023(), playerSession);
        }
        recording.start();
        recordingManager.addRecording(recording);
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("record.start.success", new Object[0]), false);
        return 1;
    }

    private static int startRecordingWithSubscenes(CommandContext<class_2168> context, String subscenes) {
        String[] subsceneNameList;
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (recordingManager.isRecording(player)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.start.already_recording", new Object[0]));
            return 0;
        }
        ArrayList<Subscene> subsceneToPlay = new ArrayList<Subscene>();
        subscenes = subscenes.replaceAll("\"", "");
        for (String subsceneName : subsceneNameList = subscenes.split(",")) {
            Subscene subscene = playerSession.getScene().getSubsceneByName(subsceneName);
            if (subscene != null) {
                subsceneToPlay.add(subscene);
                continue;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("subscene.no_exists", subsceneName));
        }
        if (subsceneNameList.length == subsceneToPlay.size()) {
            Recording recording = recordingManager.getRecording((class_1297)player);
            if (recording == null) {
                recording = new Recording((class_1309)((class_2168)context.getSource()).method_44023(), playerSession, subsceneToPlay);
            }
            recording.start();
            recordingManager.addRecording(recording);
            ((class_2168)context.getSource()).method_9226(() -> Translation.message("record.start.with_subscenes", Arrays.toString(subsceneNameList)), true);
        }
        return 1;
    }

    private static int stopRecording(CommandContext<class_2168> context) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!recordingManager.isRecording(player)) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.stop.no_recording", new Object[0]));
            return 0;
        }
        Recording recording = recordingManager.getRecording((class_1297)player);
        recording.stop();
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("record.stop.success", new Object[0]), false);
        return 1;
    }

    private static int saveRecording(CommandContext<class_2168> context, String newAnimationName) {
        PlayerSession playerSession = CommandUtil.getSession(context, ((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Recording recording = recordingManager.getRecording((class_1297)((class_2168)context.getSource()).method_44023());
        if (recording == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.save.recorded_nothing", new Object[0]));
            return 0;
        }
        if (recording.isRecording()) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.save.stop_record_before_save", new Object[0]));
            return 0;
        }
        recording.stop();
        Animation animation = playerSession.getScene().getAnimationByName(newAnimationName);
        if (animation != null) {
            if (!playerTryingOverride.contains(player)) {
                playerTryingOverride.add(((class_2168)context.getSource()).method_44023());
                ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.save.overwrite", newAnimationName, playerSession.getScene().getName(), playerSession.getChapter().getIndex()));
                return 0;
            }
            playerTryingOverride.remove(player);
        } else {
            animation = new Animation(newAnimationName, playerSession.getScene());
            playerTryingOverride.remove(player);
        }
        Animation finalAnimation = animation;
        ChooseCharacterScreen screen = new ChooseCharacterScreen(null, Translation.message("screen.story_manager.link_animation_character", new Object[0]).getString(), null, playerSession.getScene(), characterStory -> {
            if (characterStory == null) {
                ScreenUtils.sendToast((class_2561)Translation.message("global.error", new Object[0]), (class_2561)Translation.message("animation.must_link_character", new Object[0]));
                return;
            }
            try {
                finalAnimation.setCharacter((CharacterStory)characterStory);
                recording.save(finalAnimation);
                ((class_2168)context.getSource()).method_9226(() -> Translation.message("record.save.success", finalAnimation.getName(), playerSession.getScene().getName(), playerSession.getChapter().getIndex()), true);
                recordingManager.removeRecording(recording);
            }
            catch (IOException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("record.save.fail", finalAnimation.getName(), playerSession.getChapter().getIndex(), playerSession.getScene().getName()));
            }
        });
        class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)screen));
        return 1;
    }
}

