/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.chapter.Chapter;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.narrative.story.StoryValidation;
import fr.loudo.narrativecraft.util.ErrorLine;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class StoryCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"nc").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"story").then(class_2170.method_9247((String)"validate").executes(StoryCommand::validateStory))).then(class_2170.method_9247((String)"play").then(class_2170.method_9244((String)"chapter_index", (ArgumentType)IntegerArgumentType.integer()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getChapterSuggestions()).then(class_2170.method_9244((String)"scene_name", (ArgumentType)StringArgumentType.string()).suggests(NarrativeCraftMod.getInstance().getChapterManager().getSceneSuggestionsByChapter()).then(class_2170.method_9244((String)"debug", (ArgumentType)BoolArgumentType.bool()).executes(context -> StoryCommand.playStoryChapterStory((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"chapter_index"), StringArgumentType.getString((CommandContext)context, (String)"scene_name"), BoolArgumentType.getBool((CommandContext)context, (String)"debug")))))))).then(class_2170.method_9247((String)"stop").executes(StoryCommand::stopStory))));
    }

    private static int validateStory(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        player.method_64398((class_2561)class_2561.method_43473());
        player.method_64398((class_2561)Translation.message("validation.validating", new Object[0]).method_27692(class_124.field_1054));
        try {
            List<ErrorLine> results = StoryValidation.validate();
            List<ErrorLine> warnLines = results.stream().filter(ErrorLine::isWarn).toList();
            List<ErrorLine> errorLines = results.stream().filter(errorLine -> !errorLine.isWarn()).toList();
            if (errorLines.isEmpty() && warnLines.isEmpty()) {
                player.method_64398((class_2561)Translation.message("validation.validated", new Object[0]).method_27692(class_124.field_1060));
                player.method_64398((class_2561)class_2561.method_43473());
                return 1;
            }
            for (ErrorLine errorLine2 : results) {
                player.method_64398(errorLine2.toMessage());
            }
            if (!errorLines.isEmpty()) {
                player.method_64398((class_2561)Translation.message("validation.found_errors", class_2561.method_43470((String)String.valueOf(errorLines.size())).method_27692(class_124.field_1065)).method_27692(class_124.field_1061));
                player.method_64398((class_2561)class_2561.method_43473());
            }
            if (!warnLines.isEmpty()) {
                player.method_64398((class_2561)Translation.message("validation.found_warns", class_2561.method_43470((String)String.valueOf(warnLines.size())).method_27692(class_124.field_1065)).method_27692(class_124.field_1054));
            }
            return errorLines.isEmpty() ? 1 : 0;
        }
        catch (Exception e) {
            Util.sendCrashMessage((class_1657)player, e);
            player.method_64398((class_2561)class_2561.method_43473());
            return 1;
        }
    }

    private static int playStoryChapterStory(CommandContext<class_2168> context, int chapterIndex, String sceneName, boolean debug) {
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        if (!NarrativeCraftFile.getStoryFile().exists()) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("story.no_exists", new Object[0]));
            return 0;
        }
        Chapter chapter = NarrativeCraftMod.getInstance().getChapterManager().getChapterByIndex(chapterIndex);
        if (chapter == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("chapter.no_exists", chapterIndex));
            return 0;
        }
        Scene scene = chapter.getSceneByName(sceneName);
        if (scene == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("scene.no_exists", sceneName, chapterIndex));
            return 0;
        }
        if (StoryCommand.validateStory(context) == 0) {
            return 0;
        }
        if (playerSession.getStoryHandler() != null) {
            playerSession.getStoryHandler().stop();
        }
        StoryHandler storyHandler = new StoryHandler(chapter, scene, playerSession);
        storyHandler.setDebugMode(debug);
        storyHandler.start();
        return 1;
    }

    private static int stopStory(CommandContext<class_2168> context) {
        if (!((class_2168)context.getSource()).method_9259(2)) {
            return 0;
        }
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((class_1657)((class_2168)context.getSource()).method_44023());
        if (playerSession == null) {
            return 0;
        }
        StoryHandler storyHandler = playerSession.getStoryHandler();
        if (storyHandler == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)Translation.message("story.not_playing", new Object[0]));
            return 0;
        }
        storyHandler.stop();
        ((class_2168)context.getSource()).method_9226(() -> Translation.message("story.stopped", new Object[0]), false);
        return 1;
    }
}

