/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.controllers.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutscenePlayback;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeGroupsBase;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.managers.PlaybackManager;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import fr.loudo.narrativecraft.narrative.playback.Playback;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.narrative.story.StoryHandler;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneControllerScreen;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneKeyframeOptionScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;

public class CutsceneController
extends AbstractKeyframeGroupsBase<CutsceneKeyframe, CutsceneKeyframeGroup> {
    private final List<Playback> playbacks = new ArrayList<Playback>();
    private final Cutscene cutscene;
    private final CutscenePlayback cutscenePlayback;
    private Runnable onEnd;
    private boolean isPlaying;
    private int currentTick;
    private int skipTickCount;
    private int totalTick;
    private CutsceneKeyframeGroup selectedGroup;

    public CutsceneController(Environment environment, class_1657 player, Cutscene cutscene) {
        super(environment, player);
        this.cutscene = cutscene;
        this.skipTickCount = 20;
        this.isPlaying = false;
        this.keyframeGroups.addAll(cutscene.getKeyframeGroups());
        this.keyframeTriggers.addAll(cutscene.getKeyframeTriggers());
        this.cutscenePlayback = new CutscenePlayback(this, () -> {});
    }

    public void tick() {
        this.hudMessage = this.totalTick > 0 ? Translation.message("controller.cutscene.hud_tick", this.currentTick, this.totalTick).getString() : Translation.message("controller.cutscene.hud_no_tick", new Object[0]).getString();
        if (!this.isPlaying) {
            return;
        }
        ++this.currentTick;
        if (this.currentTick >= this.totalTick && this.environment == Environment.DEVELOPMENT) {
            this.pause();
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof CutsceneControllerScreen) {
                CutsceneControllerScreen screen = (CutsceneControllerScreen)class_4372;
                screen.getControllerButton().method_25355(screen.getPlayText());
            }
        } else if (this.currentTick >= this.totalTick && this.environment == Environment.PRODUCTION) {
            if (this.onEnd != null) {
                this.onEnd.run();
            }
            this.isPlaying = false;
        }
    }

    @Override
    public void startSession() {
        this.stopCurrentSession();
        Iterator<Object> iterator = this.playerSession.getController();
        if (iterator instanceof CutsceneController) {
            CutsceneController cutsceneController = (CutsceneController)((Object)iterator);
            cutsceneController.getCutscenePlayback().stop();
        }
        this.playerSession.setController(this);
        this.playbacks.clear();
        StoryHandler storyHandler = this.playerSession.getStoryHandler();
        for (Subscene subscene : this.cutscene.getSubscenes()) {
            if (storyHandler != null) {
                subscene.start((class_1937)this.playerSession.getPlayer().method_51469(), this.environment, false, storyHandler);
            } else {
                subscene.start((class_1937)this.playerSession.getPlayer().method_51469(), this.environment, false);
            }
            this.playbacks.addAll(subscene.getPlaybacks());
        }
        for (Animation animation : this.cutscene.getAnimations()) {
            Playback playback = new Playback(PlaybackManager.ID_INCREMENTER.incrementAndGet(), animation, (class_1937)this.playerSession.getPlayer().method_51469(), this.environment, false);
            if (storyHandler != null) {
                playback.startFromStory(storyHandler);
            } else {
                playback.start();
            }
            playback.setPlaying(false);
            this.playbacks.add(playback);
        }
        this.totalTick = this.calculateTotalTick();
        for (Playback playback : this.playbacks) {
            this.playerSession.getCharacterRuntimes().add(playback.getCharacterRuntime());
        }
        this.playerSession.getPlaybackManager().getPlaybacks().addAll(this.playbacks);
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        if (!this.keyframeGroups.isEmpty()) {
            this.selectedGroup = (CutsceneKeyframeGroup)this.keyframeGroups.getFirst();
            KeyframeLocation keyframeLocation = ((CutsceneKeyframe)this.selectedGroup.getKeyframes().getFirst()).getKeyframeLocation();
            this.playerSession.getPlayer().method_5859(keyframeLocation.getX(), keyframeLocation.getY(), keyframeLocation.getZ());
        } else if (!this.playbacks.isEmpty()) {
            Location location = this.playbacks.getFirst().getAnimation().getFirstLocation();
            this.playerSession.getPlayer().method_5859(location.x(), location.y(), location.z());
        }
        if (!this.keyframeGroups.isEmpty()) {
            CutsceneKeyframeGroup keyframeGroup = (CutsceneKeyframeGroup)this.keyframeGroups.getLast();
            this.keyframeGroupsCounter.set(keyframeGroup.getId());
            CutsceneKeyframe cutsceneKeyframe = this.getLastKeyframeLastGroup();
            if (cutsceneKeyframe == null) {
                return;
            }
            this.keyframesCounter.set(keyframeGroup.getId());
            for (CutsceneKeyframeGroup keyframeGroup1 : this.keyframeGroups) {
                keyframeGroup1.showKeyframes(this.playerSession.getPlayer());
            }
            this.selectedGroup.showGroupText(this.playerSession.getPlayer());
            this.updateSelectedGroupGlow();
        }
        for (KeyframeTrigger keyframeTrigger : this.keyframeTriggers) {
            keyframeTrigger.showKeyframe(this.playerSession.getPlayer());
        }
        this.pause();
    }

    @Override
    public void stopSession(boolean save) {
        for (Playback playback : this.playbacks) {
            if (playback.getCharacterRuntime().getEntity() == null || !playback.getCharacterRuntime().getEntity().method_5805()) {
                this.playerSession.getCharacterRuntimes().remove(playback.getCharacterRuntime());
            }
            playback.stop(this.environment == Environment.DEVELOPMENT);
            if (this.environment != Environment.DEVELOPMENT) continue;
            this.playerSession.getCharacterRuntimes().remove(playback.getCharacterRuntime());
        }
        this.playerSession.setController(null);
        class_310.method_1551().field_1690.field_1842 = false;
        if (this.environment == Environment.DEVELOPMENT) {
            this.playerSession.setCurrentCamera(null);
        } else if (this.environment == Environment.PRODUCTION) {
            this.playerSession.setCurrentCamera(((CutsceneKeyframe)((CutsceneKeyframeGroup)this.keyframeGroups.getLast()).getKeyframes().getLast()).getKeyframeLocation());
        }
        this.playerSession.getPlaybackManager().getPlaybacks().removeAll(this.playbacks);
        if (this.environment != Environment.DEVELOPMENT) {
            return;
        }
        for (CutsceneKeyframeGroup keyframeGroup : this.keyframeGroups) {
            keyframeGroup.hideKeyframes(this.playerSession.getPlayer());
        }
        List<CutsceneKeyframeGroup> oldData = this.cutscene.getKeyframeGroups();
        List<KeyframeTrigger> oldKeyframeTriggers = this.cutscene.getKeyframeTriggers();
        if (save) {
            this.cutscene.getKeyframeGroups().clear();
            this.cutscene.getKeyframeTriggers().clear();
            try {
                this.cutscene.getKeyframeGroups().addAll(this.keyframeGroups);
                this.cutscene.getKeyframeTriggers().addAll(this.keyframeTriggers);
                NarrativeCraftFile.updateCutsceneFile(this.cutscene.getScene());
                for (Playback playback : this.playbacks) {
                    playback.getAnimation().setSkinName(playback.getCharacterRuntime().getSkinName());
                }
                this.playerSession.getPlayer().method_64398((class_2561)Translation.message("controller.saved", new Object[0]));
            }
            catch (IOException e) {
                this.cutscene.getKeyframeGroups().removeAll(this.keyframeGroups);
                this.cutscene.getKeyframeGroups().addAll(oldData);
                this.cutscene.getKeyframeTriggers().removeAll(this.keyframeTriggers);
                this.cutscene.getKeyframeTriggers().addAll(oldKeyframeTriggers);
                for (Playback playback : this.playbacks) {
                    playback.getAnimation().setSkinName(playback.getCharacterRuntime().getOldSkinName());
                }
                this.playerSession.getPlayer().method_64398((class_2561)Translation.message("crash.global-message", new Object[0]));
                NarrativeCraftMod.LOGGER.error("Impossible to save the cutscene: ", (Throwable)e);
            }
        } else {
            for (Playback playback : this.playbacks) {
                playback.getAnimation().setSkinName(playback.getCharacterRuntime().getOldSkinName());
            }
        }
        for (KeyframeTrigger keyframeTrigger : this.keyframeTriggers) {
            keyframeTrigger.hideKeyframe(this.playerSession.getPlayer());
        }
    }

    @Override
    public class_437 getControllerScreen() {
        return new CutsceneControllerScreen(this);
    }

    @Override
    public void setCamera(Keyframe keyframe) {
        super.setCamera(keyframe);
        CutsceneKeyframe cutsceneKeyframe = (CutsceneKeyframe)keyframe;
        if (keyframe == null) {
            this.updateSelectedGroupGlow();
            this.showTextGroups();
        } else {
            this.changeTimePosition(cutsceneKeyframe.getTick(), false);
        }
    }

    private void showTextGroups() {
        for (CutsceneKeyframeGroup keyframeGroup : this.keyframeGroups) {
            keyframeGroup.showGroupText(this.playerSession.getPlayer());
        }
    }

    @Override
    public class_437 keyframeOptionScreen(Keyframe keyframe, boolean hide) {
        return new CutsceneKeyframeOptionScreen((CutsceneKeyframe)keyframe, this.playerSession, hide);
    }

    @Override
    public void removeKeyframe(CutsceneKeyframe keyframe) {
        CutsceneKeyframeGroup keyframeGroup = (CutsceneKeyframeGroup)this.getKeyframeGroupOfKeyframe(keyframe);
        List keyframes = keyframeGroup.getKeyframes();
        super.removeKeyframe(keyframe);
        if (!keyframes.isEmpty()) {
            keyframeGroup.showGroupText(this.playerSession.getPlayer());
        } else {
            this.keyframeGroupsCounter.decrementAndGet();
            this.keyframeGroups.remove(keyframeGroup);
            for (int i = 0; i < this.keyframeGroups.size(); ++i) {
                CutsceneKeyframeGroup keyframeGroup1 = (CutsceneKeyframeGroup)this.keyframeGroups.get(i);
                keyframeGroup1.showGroupText(this.playerSession.getPlayer());
                keyframeGroup1.setId(i + 1);
                keyframeGroup1.showGroupText(this.playerSession.getPlayer());
            }
            if (!this.keyframeGroups.isEmpty()) {
                this.selectedGroup = (CutsceneKeyframeGroup)this.keyframeGroups.getLast();
                this.updateSelectedGroupGlow();
            } else {
                this.selectedGroup = null;
            }
        }
    }

    public void resume() {
        if (this.atMaxTick()) {
            return;
        }
        this.isPlaying = true;
        for (Playback playback : this.playbacks) {
            playback.setPlaying(true);
        }
    }

    public void pause() {
        this.isPlaying = false;
        for (Playback playback : this.playbacks) {
            playback.setPlaying(false);
        }
    }

    public CutsceneKeyframeGroup createKeyframeGroup() {
        CutsceneKeyframeGroup keyframeGroup;
        if (this.environment != Environment.DEVELOPMENT) {
            return null;
        }
        CutsceneKeyframe lastKeyframe = this.getLastKeyframeLastGroup();
        this.selectedGroup = keyframeGroup = new CutsceneKeyframeGroup(this.keyframeGroupsCounter.incrementAndGet());
        this.keyframeGroups.add(keyframeGroup);
        this.createKeyframe();
        if (lastKeyframe != null && this.totalTick > 0) {
            lastKeyframe.setTransitionDelayTick(this.currentTick - lastKeyframe.getTick());
        }
        keyframeGroup.showGroupText(this.playerSession.getPlayer());
        this.updateSelectedGroupGlow();
        return keyframeGroup;
    }

    public void updateSelectedGroupGlow() {
        for (CutsceneKeyframeGroup keyframeGroup : this.keyframeGroups) {
            if (keyframeGroup.getId() == this.selectedGroup.getId()) {
                keyframeGroup.showGlow(this.playerSession.getPlayer());
                continue;
            }
            keyframeGroup.hideGlow(this.playerSession.getPlayer());
        }
    }

    public CutsceneKeyframe createKeyframe() {
        if (this.environment != Environment.DEVELOPMENT) {
            return null;
        }
        int pathTime = 0;
        CutsceneKeyframe lastKeyframe = this.getLastKeyframeLastGroup();
        if (lastKeyframe != null && this.totalTick > 0) {
            pathTime = this.currentTick - lastKeyframe.getTick();
        }
        CutsceneKeyframe keyframe = new CutsceneKeyframe(this.keyframesCounter.incrementAndGet(), this.getKeyframeLocationFromPlayer(), this.currentTick, 0, pathTime);
        if (this.totalTick > 0) {
            block0: for (CutsceneKeyframeGroup keyframeGroup : this.keyframeGroups) {
                for (int i = 0; i < keyframeGroup.getKeyframes().size(); ++i) {
                    if (((CutsceneKeyframe)keyframeGroup.getKeyframes().get(i)).getTick() <= this.currentTick) continue;
                    CutsceneKeyframe before = i > 0 ? (CutsceneKeyframe)keyframeGroup.getKeyframes().get(i - 1) : (CutsceneKeyframe)keyframeGroup.getKeyframes().get(i);
                    CutsceneKeyframe after = (CutsceneKeyframe)keyframeGroup.getKeyframes().get(i);
                    keyframe.setPathTick(this.currentTick - before.getTick());
                    after.setPathTick(after.getTick() - this.currentTick);
                    this.selectedGroup = keyframeGroup;
                    this.selectedGroup.getKeyframes().add(i, keyframe);
                    this.updateCurrentTick(keyframe.getTick());
                    break block0;
                }
            }
        }
        this.selectedGroup.addKeyframe(keyframe);
        keyframe.setParentGroup(((CutsceneKeyframe)this.selectedGroup.getKeyframes().getFirst()).getId() == keyframe.getId());
        keyframe.showKeyframe(this.playerSession.getPlayer());
        keyframe.getCamera().method_5834(true);
        keyframe.updateEntityData(this.playerSession.getPlayer());
        this.updateSelectedGroupGlow();
        return keyframe;
    }

    public void drawLinesBetweenKeyframes(class_4587 poseStack) {
        if (this.playerSession.getCurrentCamera() != null || this.environment != Environment.DEVELOPMENT) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4587.class_4665 matrix4f = poseStack.method_23760();
        for (CutsceneKeyframeGroup keyframeGroup : this.keyframeGroups) {
            class_4588 vertexConsumer = client.method_22940().method_23000().getBuffer(class_1921.method_49043((double)1.0));
            for (int i = 0; i < keyframeGroup.getKeyframes().size() - 1; ++i) {
                CutsceneKeyframe firstKeyFrame = (CutsceneKeyframe)keyframeGroup.getKeyframes().get(i);
                CutsceneKeyframe secondKeyFrame = (CutsceneKeyframe)keyframeGroup.getKeyframes().get(i + 1);
                KeyframeLocation startPos = firstKeyFrame.getKeyframeLocation();
                KeyframeLocation endPos = secondKeyFrame.getKeyframeLocation();
                double x1 = startPos.getX() - cameraPos.field_1352;
                double y1 = startPos.getY() - cameraPos.field_1351;
                double z1 = startPos.getZ() - cameraPos.field_1350;
                double x2 = endPos.getX() - cameraPos.field_1352;
                double y2 = endPos.getY() - cameraPos.field_1351;
                double z2 = endPos.getZ() - cameraPos.field_1350;
                vertexConsumer.method_61032(matrix4f, new Vector3f((float)x1, (float)y1, (float)z1)).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_22914(0.0f, 1.0f, 0.0f);
                vertexConsumer.method_61032(matrix4f, new Vector3f((float)x2, (float)y2, (float)z2)).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_22914(0.0f, 1.0f, 0.0f);
            }
            client.method_22940().method_23000().method_22993();
        }
    }

    public CutsceneKeyframe getLastKeyframeLastGroup() {
        if (this.keyframeGroups.isEmpty()) {
            return null;
        }
        List keyframes = ((CutsceneKeyframeGroup)this.keyframeGroups.getLast()).getKeyframes();
        if (keyframes.isEmpty()) {
            return null;
        }
        return (CutsceneKeyframe)keyframes.getLast();
    }

    public void updateCurrentTick(int tick) {
        List groups = this.keyframeGroups;
        int initialFirstTick = 0;
        if (!groups.isEmpty() && !((CutsceneKeyframeGroup)groups.getFirst()).getKeyframes().isEmpty()) {
            initialFirstTick = ((CutsceneKeyframe)((CutsceneKeyframeGroup)groups.getFirst()).getKeyframes().getFirst()).getTick();
        }
        int referenceTick = 0;
        for (int i = 0; i < groups.size(); ++i) {
            List prevGroup;
            CutsceneKeyframeGroup group = (CutsceneKeyframeGroup)groups.get(i);
            List keyframes = group.getKeyframes();
            if (keyframes.isEmpty()) continue;
            if (i > 0 && !(prevGroup = ((CutsceneKeyframeGroup)groups.get(i - 1)).getKeyframes()).isEmpty()) {
                CutsceneKeyframe lastPrev = (CutsceneKeyframe)prevGroup.getLast();
                referenceTick += lastPrev.getTransitionDelayTick();
            }
            for (int j = 0; j < keyframes.size(); ++j) {
                int newTick;
                CutsceneKeyframe current = (CutsceneKeyframe)keyframes.get(j);
                if (i == 0 && j == 0) {
                    newTick = initialFirstTick + current.getStartDelayTick();
                } else if (j > 0) {
                    CutsceneKeyframe previous = (CutsceneKeyframe)keyframes.get(j - 1);
                    newTick = previous.getTick() + previous.getStartDelayTick() + current.getPathTick();
                } else {
                    newTick = referenceTick + current.getStartDelayTick();
                }
                current.setTick(newTick);
                referenceTick = newTick;
            }
        }
        this.changeTimePosition(tick, true);
    }

    public boolean atMaxTick() {
        return this.currentTick >= this.totalTick;
    }

    public void nextSecondSkip() {
        this.changeTimePosition(this.currentTick + this.skipTickCount, true);
    }

    public void previousSecondSkip() {
        this.changeTimePosition(Math.max(0, this.currentTick - this.skipTickCount), true);
    }

    public void changeTimePosition(int newTick, boolean seamless) {
        this.currentTick = Math.min(newTick, this.totalTick);
        for (Playback playback : this.playbacks) {
            playback.changeLocationByTick(newTick, seamless);
        }
    }

    public boolean isLastKeyframe(CutsceneKeyframe keyframe) {
        if (this.keyframeGroups.isEmpty()) {
            return false;
        }
        if (((CutsceneKeyframeGroup)this.keyframeGroups.getLast()).getKeyframes().isEmpty()) {
            return false;
        }
        return ((CutsceneKeyframeGroup)this.keyframeGroups.getLast()).isLastKeyframe(keyframe);
    }

    private int calculateTotalTick() {
        if (this.totalTick == 0) {
            int total = 0;
            int count = 0;
            for (Subscene subscene : this.cutscene.getSubscenes()) {
                for (Playback playback : subscene.getPlaybacks()) {
                    total += playback.getMaxTick();
                    ++count;
                }
            }
            for (Playback playback : this.playbacks) {
                total += playback.getMaxTick();
                ++count;
            }
            if (count == 0) {
                return 0;
            }
            this.totalTick = total / count;
        }
        return this.totalTick;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
        for (Playback playback : this.playbacks) {
            playback.setPlaying(playing);
        }
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public int getSkipTickCount() {
        return this.skipTickCount;
    }

    public void setSkipTickCount(int skipTickCount) {
        this.skipTickCount = skipTickCount;
    }

    public void setSelectedGroup(CutsceneKeyframeGroup selectedGroup) {
        this.selectedGroup = selectedGroup;
        this.updateSelectedGroupGlow();
    }

    public List<Playback> getPlaybacks() {
        return this.playbacks;
    }

    public Cutscene getCutscene() {
        return this.cutscene;
    }

    public int getTotalTick() {
        return this.totalTick;
    }

    public CutsceneKeyframeGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    public CutscenePlayback getCutscenePlayback() {
        return this.cutscenePlayback;
    }

    public Runnable getOnEnd() {
        return this.onEnd;
    }

    public void setOnEnd(Runnable onEnd) {
        this.onEnd = onEnd;
    }
}

