/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.chapter.scene.data;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.SceneData;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.narrative.keyframes.keyframeTrigger.KeyframeTrigger;
import java.util.ArrayList;
import java.util.List;

public class Cutscene
extends SceneData {
    private transient List<Subscene> subscenes = new ArrayList<Subscene>();
    private transient List<Animation> animations = new ArrayList<Animation>();
    private List<CutsceneKeyframeGroup> keyframeGroups = new ArrayList<CutsceneKeyframeGroup>();
    private List<KeyframeTrigger> keyframeTriggers = new ArrayList<KeyframeTrigger>();

    public Cutscene(String name, String description, Scene scene) {
        super(name, description, scene);
    }

    public List<String> getSubscenesName() {
        return this.getSubscenes().stream().map(NarrativeEntry::getName).toList();
    }

    public List<Subscene> getSubscenes() {
        if (this.subscenes == null) {
            this.subscenes = new ArrayList<Subscene>();
        }
        return this.subscenes;
    }

    public List<String> getAnimationsName() {
        return this.getAnimations().stream().map(NarrativeEntry::getName).toList();
    }

    public List<Animation> getAnimations() {
        if (this.animations == null) {
            this.animations = new ArrayList<Animation>();
        }
        return this.animations;
    }

    public void addKeyframeGroup(CutsceneKeyframeGroup keyframeGroup) {
        if (this.keyframeGroups.contains(keyframeGroup)) {
            return;
        }
        this.keyframeGroups.add(keyframeGroup);
    }

    public void removeKeyframeGroup(CutsceneKeyframeGroup keyframeGroup) {
        this.keyframeGroups.remove(keyframeGroup);
    }

    public List<CutsceneKeyframeGroup> getKeyframeGroups() {
        if (this.keyframeGroups == null) {
            this.keyframeGroups = new ArrayList<CutsceneKeyframeGroup>();
        }
        return this.keyframeGroups;
    }

    public List<KeyframeTrigger> getKeyframeTriggers() {
        if (this.keyframeTriggers == null) {
            this.keyframeTriggers = new ArrayList<KeyframeTrigger>();
        }
        return this.keyframeTriggers;
    }
}

